/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.armor;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class WaterTankModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_WATER_TANK = "Water Tank";
    public static final String WATER_TANK_SIZE = "Tank Size";
    public static final String ACTIVATION_PERCENT = "Heat Activation Percent";
    ItemStack bucketWater = new ItemStack(Items.field_151131_as);

    public WaterTankModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(WATER_TANK_SIZE, 200.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addBaseProperty(ACTIVATION_PERCENT, 0.5);
        this.addTradeoffProperty("Activation Percent", ACTIVATION_PERCENT, 0.5, "%");
        this.addTradeoffProperty(WATER_TANK_SIZE, WATER_TANK_SIZE, 800.0, " buckets");
        this.addTradeoffProperty(WATER_TANK_SIZE, "Weight", 4000.0, "g");
        this.addInstallCost(this.bucketWater);
        this.addInstallCost(new ItemStack(Blocks.field_150359_w, 8));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
    }

    @Override
    public String getTextureFile() {
        return null;
    }

    @Override
    public IIcon getIcon(ItemStack item) {
        return this.bucketWater.func_77954_c();
    }

    @Override
    public String getCategory() {
        return "Environment";
    }

    @Override
    public String getDataName() {
        return MODULE_WATER_TANK;
    }

    @Override
    public String getUnlocalizedName() {
        return "waterTank";
    }

    @Override
    public String getDescription() {
        return "Store water which can later be used to cool yourself in emergency situations.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double maxHeat;
        double currentHeat;
        boolean isRaining;
        Block block;
        if (MuseItemUtils.getWaterLevel(item) > ModuleManager.computeModularProperty(item, WATER_TANK_SIZE)) {
            MuseItemUtils.setWaterLevel(item, ModuleManager.computeModularProperty(item, WATER_TANK_SIZE));
        }
        if (((block = player.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v))) == Blocks.field_150355_j || block == Blocks.field_150358_i) && MuseItemUtils.getWaterLevel(item) < ModuleManager.computeModularProperty(item, WATER_TANK_SIZE)) {
            MuseItemUtils.setWaterLevel(item, MuseItemUtils.getWaterLevel(item) + 1.0);
        }
        int xCoord = MathHelper.func_76128_c((double)player.field_70165_t);
        int zCoord = MathHelper.func_76128_c((double)player.field_70161_v);
        boolean bl = isRaining = player.field_70170_p.func_72959_q().func_76935_a(xCoord, zCoord).func_76744_g() > 0 && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I());
        if (isRaining && player.field_70170_p.func_72937_j(xCoord, MathHelper.func_76128_c((double)player.field_70163_u) + 1, zCoord) && player.field_70170_p.func_82737_E() % 5L == 0L && MuseItemUtils.getWaterLevel(item) < ModuleManager.computeModularProperty(item, WATER_TANK_SIZE)) {
            MuseItemUtils.setWaterLevel(item, MuseItemUtils.getWaterLevel(item) + 1.0);
        }
        if ((currentHeat = MuseHeatUtils.getPlayerHeat(player)) / (maxHeat = MuseHeatUtils.getMaxHeat(player)) >= ModuleManager.computeModularProperty(item, ACTIVATION_PERCENT) && MuseItemUtils.getWaterLevel(item) > 0.0) {
            MuseHeatUtils.coolPlayer(player, 1.0);
            MuseItemUtils.setWaterLevel(item, MuseItemUtils.getWaterLevel(item) - 1.0);
            for (int i = 0; i < 4; ++i) {
                player.field_70170_p.func_72869_a("smoke", player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

