/*
 * Decompiled with CFR 0.152.
 */
package defense.common.tile;

import defense.api.FrequencyGrid;
import defense.api.IBlockFrequency;
import defense.api.ILauncherController;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Pos3D;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.tile.TileEntityElectricBlock;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLauncherPrefab
extends TileEntityElectricBlock
implements ILauncherController,
IComputerIntegration,
IBlockFrequency {
    protected Pos3D targetPos = null;
    protected int frequency = 0;
    private boolean initiated = false;

    public TileLauncherPrefab(String name, double baseMaxEnergy) {
        super(name, baseMaxEnergy);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.initiated) {
            this.initiate();
            this.initiated = true;
        }
    }

    public void initiate() {
        FrequencyGrid.instance().register(this);
    }

    public void func_145843_s() {
        FrequencyGrid.instance().unregister(this);
        super.func_145843_s();
    }

    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.frequency = dataStream.readInt();
            if (dataStream.readBoolean()) {
                this.targetPos = new Pos3D(dataStream.readDouble(), dataStream.readDouble(), dataStream.readDouble());
            }
        }
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.frequency);
        if (this.targetPos != null) {
            data.add(true);
            data.add(this.targetPos.xPos);
            data.add(this.targetPos.yPos);
            data.add(this.targetPos.zPos);
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    @Override
    public Pos3D getTarget() {
        if (this.targetPos == null) {
            this.targetPos = this.getLauncherType() == ILauncherController.LauncherType.CRUISE ? new Pos3D((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) : new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e);
        }
        return this.targetPos;
    }

    @Override
    public void setTarget(Pos3D target) {
        this.targetPos = target.floor();
    }

    public String[] getMethods() {
        return new String[]{"launch", "getTarget", "setTarget", "canLaunch", "getMissile"};
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                this.launch();
                return null;
            }
            case 1: {
                return new Object[]{this.getTarget().xPos, this.getTarget().yPos, this.getTarget().zPos};
            }
            case 2: {
                if (arguments[0] != null && arguments[1] != null && arguments[2] != null) {
                    try {
                        this.setTarget(new Pos3D(((Double)arguments[0]).doubleValue(), ((Double)arguments[1]).doubleValue(), ((Double)arguments[2]).doubleValue()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Target Parameter is Invalid.");
                    }
                }
                return null;
            }
            case 3: {
                return new Object[]{this.canLaunch()};
            }
            case 4: {
                if (this.getMissile() != null) {
                    return new Object[]{this.getMissile().getExplosiveType().getMissileName()};
                }
                return null;
            }
        }
        throw new Exception("Invalid Launcher Function.");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetPos = Pos3D.read((NBTTagCompound)nbt.func_74775_l("target"));
        this.frequency = nbt.func_74762_e("frequency");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.targetPos != null) {
            nbt.func_74782_a("target", (NBTBase)this.targetPos.write(new NBTTagCompound()));
        }
        nbt.func_74768_a("frequency", this.frequency);
    }
}

