/*
 * Decompiled with CFR 0.152.
 */
package defense.common.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.IItemTracker;
import defense.common.CreativeTabHandler;
import defense.common.item.TextureTracker;
import java.util.List;
import mekanism.common.item.ItemEnergized;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemTracker
extends ItemEnergized
implements IItemTracker {
    private static final long ENERGY_PER_TICK = 1L;

    public ItemTracker() {
        super(100000.0);
        this.func_77655_b("tracker");
        this.func_77637_a(CreativeTabHandler.INSTANCE);
        this.func_111206_d("defense:tracker");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        if (par1IconRegister instanceof TextureMap) {
            ((TextureMap)par1IconRegister).setTextureEntry("defense:tracker", (TextureAtlasSprite)new TextureTracker());
            this.field_77791_bV = ((TextureMap)par1IconRegister).getTextureExtry("defense:tracker");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, par3List, par4);
        Entity trackingEntity = this.getTrackingEntity((World)FMLClientHandler.instance().getClient().field_71441_e, itemStack);
        if (trackingEntity != null) {
            par3List.add(LangUtils.localize((String)"info.tracker.tracking") + " " + trackingEntity.func_70005_c_());
        }
        par3List.add(LangUtils.localize((String)"info.tracker.tooltip"));
    }

    @Override
    public void setTrackingEntity(ItemStack itemStack, Entity entity) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (entity != null) {
            itemStack.field_77990_d.func_74768_a("trackingEntity", entity.func_145782_y());
        }
    }

    @Override
    public Entity getTrackingEntity(World worldObj, ItemStack itemStack) {
        if (worldObj != null && itemStack.field_77990_d != null) {
            int trackingID = itemStack.field_77990_d.func_74762_e("trackingEntity");
            return worldObj.func_73045_a(trackingID);
        }
        return null;
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        super.func_77622_d(par1ItemStack, par2World, par3EntityPlayer);
        this.setTrackingEntity(par1ItemStack, (Entity)par3EntityPlayer);
    }

    public void func_77663_a(ItemStack itemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, par2World, par3Entity, par4, par5);
        if (par3Entity instanceof EntityPlayer) {
            Entity trackingEntity;
            EntityPlayer player = (EntityPlayer)par3Entity;
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == this && par2World.func_72820_D() % 20L == 0L && (trackingEntity = this.getTrackingEntity(par2World, itemStack)) != null) {
                if (this.getEnergy(itemStack) < 1.0) {
                    this.setTrackingEntity(itemStack, null);
                }
                this.setEnergy(itemStack, this.getEnergy(itemStack) - 1.0);
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            if (this.getEnergy(itemStack) > 1.0) {
                this.setTrackingEntity(itemStack, entity);
                player.func_145747_a((IChatComponent)new ChatComponentText(LangUtils.localize((String)"message.tracker.nowtrack") + " " + entity.func_70005_c_()));
                return true;
            }
            player.func_145747_a((IChatComponent)new ChatComponentText(LangUtils.localize((String)"message.tracker.nopower")));
        }
        return false;
    }
}

