/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.thread;

import defense.common.explosive.thread.ThreadExplosion;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class ThreadLargeExplosion
extends ThreadExplosion {
    public IThreadCallBack callBack;

    public ThreadLargeExplosion(World world, Pos3D position, int range, float energy, Entity source, IThreadCallBack cb) {
        super(world, position, range, energy, source);
        this.callBack = cb;
    }

    public ThreadLargeExplosion(World world, Pos3D position, int range, float energy, Entity source) {
        this(world, position, range, energy, source, new IThreadCallBack(){

            @Override
            public float getResistance(World world, Pos3D pos, Pos3D targetPosition, Entity source, Block block) {
                float resistance = 0.0f;
                resistance = block instanceof BlockLiquid || block instanceof IFluidBlock ? 0.25f : block.getExplosionResistance(source, world, (int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos, pos.xPos, pos.yPos, pos.zPos);
                return resistance;
            }
        });
    }

    @Override
    public void run() {
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)this.explosionRadius));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                Pos3D delta = new Pos3D(Math.sin(theta) * Math.cos(phi), Math.cos(theta), Math.sin(theta) * Math.sin(phi));
                Pos3D t = this.position.clone();
                float d = 0.3f;
                for (float power = this.explosionEnergy - this.explosionEnergy * this.worldObj.field_73012_v.nextFloat() / 2.0f; power > 0.0f && !(t.distance(this.position) > (double)this.explosionRadius); power -= d * 0.75f * 10.0f) {
                    Block block = this.worldObj.func_147439_a((int)t.xPos, (int)t.yPos, (int)t.zPos);
                    if (!this.worldObj.func_147437_c((int)t.xPos, (int)t.yPos, (int)t.zPos) && block.func_149712_f(this.worldObj, (int)t.xPos, (int)t.yPos, (int)t.zPos) >= 0.0f && (power -= this.callBack.getResistance(this.worldObj, this.position, t, this.explosionSource, block)) > 0.0f) {
                        this.results.add(t.clone());
                    }
                    t.translate(delta);
                }
            }
        }
        super.run();
    }

    public static interface IThreadCallBack {
        public float getResistance(World var1, Pos3D var2, Pos3D var3, Entity var4, Block var5);
    }
}

