/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.ExplosionEvent;
import defense.api.IExplosion;
import defense.client.model.missile.ModelMissileBase;
import defense.common.entity.EntityExplosion;
import defense.common.entity.EntityMissile;
import java.util.List;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class Blast
extends Explosion
implements IExplosion {
    public Pos3D position;
    public World field_77287_j;
    public EntityExplosion controller = null;
    protected int callCount = 0;

    public Blast(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.position = new Pos3D(x, y, z);
        this.field_77287_j = world;
    }

    public Blast(World world, Pos3D pos, Entity entity, float size) {
        super(world, entity, pos.xPos, pos.yPos, pos.zPos, size);
        this.position = pos;
        this.field_77287_j = world;
    }

    public Blast(Entity entity, float size) {
        super(entity.field_70170_p, entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, size);
        this.position = new Pos3D(entity);
        this.field_77287_j = entity.field_70170_p;
    }

    protected void doPreExplode() {
    }

    public final void preExplode() {
        ExplosionEvent.PreExplosionEvent evt = new ExplosionEvent.PreExplosionEvent(this.field_77287_j, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doPreExplode();
        }
    }

    protected abstract void doExplode();

    public final void onExplode() {
        ExplosionEvent.DoExplosionEvent evt = new ExplosionEvent.DoExplosionEvent(this.field_77287_j, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doExplode();
            ++this.callCount;
        }
    }

    protected void doPostExplode() {
    }

    public final void postExplode() {
        ExplosionEvent.PostExplosionEvent evt = new ExplosionEvent.PostExplosionEvent(this.field_77287_j, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doPostExplode();
        }
    }

    public void func_77278_a() {
    }

    public void func_77279_a(boolean par1) {
    }

    @Override
    public void explode() {
        ExplosionEvent.ExplosionConstructionEvent evt = new ExplosionEvent.ExplosionConstructionEvent(this.field_77287_j, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            if (this.proceduralInterval() > 0) {
                if (!this.field_77287_j.field_72995_K) {
                    this.field_77287_j.func_72838_d((Entity)new EntityExplosion(this));
                }
            } else {
                this.doPreExplode();
                this.doExplode();
                this.doPostExplode();
            }
        }
    }

    public int countIncrement() {
        return 1;
    }

    @Override
    public float getRadius() {
        return this.field_77280_f;
    }

    @Override
    public long getEnergy() {
        return 0L;
    }

    public int proceduralInterval() {
        return -1;
    }

    protected void doDamageEntities(float radius, float power) {
        this.doDamageEntities(radius, power, true);
    }

    protected void doDamageEntities(float radius, float power, boolean destroyItem) {
        Pos3D minCoord = this.position.clone();
        minCoord.translate((double)(-radius - 1.0f), (double)(-radius - 1.0f), (double)(-radius - 1.0f));
        Pos3D maxCoord = this.position.clone();
        maxCoord.translate((double)(radius + 1.0f), (double)(radius + 1.0f), (double)(radius + 1.0f));
        List allEntities = this.field_77287_j.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)minCoord.xPos, (double)minCoord.yPos, (double)minCoord.zPos, (double)maxCoord.xPos, (double)maxCoord.yPos, (double)maxCoord.zPos));
        Vec3 var31 = Vec3.func_72443_a((double)this.position.xPos, (double)this.position.yPos, (double)this.position.zPos);
        for (int i = 0; i < allEntities.size(); ++i) {
            double distance;
            Entity entity = (Entity)allEntities.get(i);
            if (this.onDamageEntity(entity)) continue;
            if (entity instanceof EntityMissile) {
                ((EntityMissile)entity).setExplode();
                continue;
            }
            if (entity instanceof EntityItem && !destroyItem || !((distance = entity.func_70011_f(this.position.xPos, this.position.yPos, this.position.zPos) / (double)radius) <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.position.xPos;
            double yDifference = entity.field_70163_u - this.position.yPos;
            double zDifference = entity.field_70161_v - this.position.zPos;
            double var35 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= var35;
            yDifference /= var35;
            zDifference /= var35;
            double var34 = this.field_77287_j.func_72842_a(var31, entity.field_70121_D);
            double var36 = (1.0 - distance) * var34;
            int damage = 0;
            damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)power + 1.0);
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
            entity.field_70159_w += xDifference * var36;
            entity.field_70181_x += yDifference * var36;
            entity.field_70179_y += zDifference * var36;
        }
    }

    protected boolean onDamageEntity(Entity entity) {
        return false;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.callCount = nbt.func_74762_e("callCount");
        this.field_77280_f = nbt.func_74760_g("explosionSize");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("callCount", this.callCount);
        nbt.func_74776_a("explosionSize", this.field_77280_f);
    }

    public boolean isMovable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getRenderModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getRenderResource() {
        return null;
    }
}

