/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import defense.common.explosion.Explosion;
import defense.common.explosive.Explosive;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ExplosiveRegistry {
    private static int maxID = 0;
    private static final HashMap<Integer, Explosive> idToExplosiveMap = new HashMap();
    private static final BiMap<Integer, String> idToNameMap = HashBiMap.create();

    public static Explosive register(Explosive zhaPin) {
        if (!ExplosiveRegistry.isRegistered(zhaPin)) {
            int nextID = maxID++;
            idToExplosiveMap.put(nextID, zhaPin);
            idToNameMap.put((Object)nextID, (Object)zhaPin.getUnlocalizedName());
            return zhaPin;
        }
        return null;
    }

    public static boolean isRegistered(Explosive explosive) {
        return idToNameMap.containsKey((Object)explosive.getUnlocalizedName());
    }

    public static int getID(String unlocalizedName) {
        return (Integer)idToNameMap.inverse().get((Object)unlocalizedName);
    }

    public static Explosive get(String name) {
        return idToExplosiveMap.get(ExplosiveRegistry.getID(name));
    }

    public static Explosive get(int haoMa) {
        return idToExplosiveMap.get(haoMa);
    }

    public static String getName(int haoMa) {
        return (String)idToNameMap.get((Object)haoMa);
    }

    public static Collection<Explosive> getExplosives() {
        return idToExplosiveMap.values();
    }

    public static Collection<Explosion> getAllMissles() {
        HashSet<Explosion> missiles = new HashSet<Explosion>();
        for (Explosive explosive : idToExplosiveMap.values()) {
            if (!(explosive instanceof Explosion)) continue;
            missiles.add((Explosion)explosive);
        }
        return missiles;
    }

    public static HashMap<Integer, Explosive> getAll() {
        return idToExplosiveMap;
    }
}

