/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion.missile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.ITarget;
import defense.client.model.missile.ModelAntiMissileMissile;
import defense.client.model.missile.ModelMissileBase;
import defense.common.entity.EntityMissile;
import defense.common.explosion.missile.Missile;
import defense.common.explosive.blast.BlastRepulsive;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MissileAntiBallistic
extends Missile {
    public static final int ABMRange = 30;

    public MissileAntiBallistic() {
        super("antiBallistic", 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        return new ModelAntiMissileMissile();
    }

    @Override
    public void update(EntityMissile missileObj) {
        if (missileObj.lockedTarget != null) {
            Pos3D target = new Pos3D(missileObj.lockedTarget);
            if (missileObj.lockedTarget.field_70128_L) {
                missileObj.explode();
                return;
            }
            if (missileObj.lockedTarget instanceof ITarget && ((ITarget)missileObj.lockedTarget).getType() == ITarget.TargetType.MISSILE && ((ITarget)missileObj.lockedTarget).canBeTargeted(this)) {
                target = ((ITarget)missileObj.lockedTarget).getPredictedPosition(4);
            }
            missileObj.field_70159_w = (target.xPos - missileObj.field_70165_t) * (double)0.3f;
            missileObj.field_70181_x = (target.yPos - missileObj.field_70163_u) * (double)0.3f;
            missileObj.field_70179_y = (target.zPos - missileObj.field_70161_v) * (double)0.3f;
            return;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(missileObj.field_70165_t - 30.0), (double)(missileObj.field_70163_u - 30.0), (double)(missileObj.field_70161_v - 30.0), (double)(missileObj.field_70165_t + 30.0), (double)(missileObj.field_70163_u + 30.0), (double)(missileObj.field_70161_v + 30.0));
        Entity nearestEntity = missileObj.field_70170_p.func_72857_a(ITarget.class, bounds, (Entity)missileObj);
        if (nearestEntity instanceof ITarget && ((ITarget)nearestEntity).getType() == ITarget.TargetType.MISSILE) {
            if (((ITarget)nearestEntity).canBeTargeted(this)) {
                missileObj.lockedTarget = nearestEntity;
                missileObj.didTargetLockBefore = true;
                missileObj.field_70170_p.func_72956_a((Entity)missileObj, "defense:targetlocked", 5.0f, 0.9f);
            }
        } else {
            missileObj.field_70159_w = missileObj.deltaPathX / (double)missileObj.missileFlightTime;
            missileObj.field_70179_y = missileObj.deltaPathZ / (double)missileObj.missileFlightTime;
            if (missileObj.didTargetLockBefore) {
                missileObj.explode();
            }
        }
    }

    @Override
    public boolean isCruise() {
        return true;
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastRepulsive(world, entity, x, y, z, 6.0f).setDestroyItems().explode();
    }
}

