/*
 * Decompiled with CFR 0.152.
 */
package defense.common.entity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import defense.api.ExplosionEvent;
import defense.api.ExplosiveType;
import defense.api.IExplosive;
import defense.api.IExplosiveContainer;
import defense.common.DefenseTechBlocks;
import defense.common.explosive.ExplosiveRegistry;
import io.netty.buffer.ByteBuf;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityExplosive
extends Entity
implements IEntityAdditionalSpawnData,
IExplosiveContainer {
    public int fuse = 0;
    public int explosiveID = 0;
    private byte orientation = (byte)3;
    public NBTTagCompound nbtData = new NBTTagCompound();

    public EntityExplosive(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityExplosive(World par1World, Pos3D position, byte orientation, int explosiveID) {
        this(par1World);
        this.func_70107_b(position.xPos, position.yPos, position.zPos);
        float var8 = (float)(Math.random() * Math.PI * 2.0);
        this.field_70159_w = -((float)Math.sin(var8)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(var8)) * 0.02f;
        this.field_70169_q = position.xPos;
        this.field_70167_r = position.yPos;
        this.field_70166_s = position.zPos;
        this.explosiveID = explosiveID;
        this.fuse = ExplosiveRegistry.get(explosiveID).getYinXin();
        this.orientation = orientation;
        ExplosiveRegistry.get(explosiveID).onPreDetonation(par1World, this);
    }

    public EntityExplosive(World par1World, Pos3D position, int explosiveID, byte orientation, NBTTagCompound nbtData) {
        this(par1World, position, orientation, explosiveID);
        this.nbtData = nbtData;
    }

    public String func_70005_c_() {
        return "Explosives";
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, ExplosiveType.BLOCK, ExplosiveRegistry.get(this.explosiveID));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.isCanceled()) {
                DefenseTechBlocks.blockExplosive.func_149697_b(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.explosiveID, 0);
                this.func_70106_y();
                return;
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w *= 0.95;
        this.field_70181_x -= 0.045;
        this.field_70179_y *= 0.95;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.fuse < 1) {
            this.explode();
        } else {
            ExplosiveRegistry.get(this.explosiveID).onDetonation(this.field_70170_p, new Pos3D(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.fuse);
        }
        --this.fuse;
        super.func_70071_h_();
    }

    public void explode() {
        this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        this.getExplosiveType().createExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this);
        this.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.fuse = nbt.func_74771_c("Fuse");
        this.explosiveID = nbt.func_74762_e("explosiveID");
        this.nbtData = nbt.func_74775_l("data");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Fuse", (byte)this.fuse);
        nbt.func_74768_a("explosiveID", this.explosiveID);
        nbt.func_74782_a("data", (NBTBase)this.nbtData);
    }

    public float func_70053_R() {
        return 0.5f;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.orientation);
    }

    public void setDirection(ForgeDirection facingDirection) {
        this.orientation = (byte)facingDirection.ordinal();
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.explosiveID);
        data.writeInt(this.fuse);
        data.writeByte((int)this.orientation);
    }

    public void readSpawnData(ByteBuf data) {
        this.explosiveID = data.readInt();
        this.fuse = data.readInt();
        this.orientation = data.readByte();
    }

    @Override
    public IExplosive getExplosiveType() {
        return ExplosiveRegistry.get(this.explosiveID);
    }

    @Override
    public NBTTagCompound getTagCompound() {
        return this.nbtData;
    }
}

