/*
 * Decompiled with CFR 0.152.
 */
package defense.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.ITier;
import defense.client.render.block.BlockRenderingHandler;
import defense.common.DefenseTechBlocks;
import defense.common.DefenseTechItems;
import defense.common.base.IBlockActivate;
import defense.common.block.BlockBase;
import defense.common.item.ItemBlockMachine;
import defense.common.tile.TileCruiseLauncher;
import defense.common.tile.TileEMPTower;
import defense.common.tile.TileLauncherBase;
import defense.common.tile.TileLauncherFrame;
import defense.common.tile.TileLauncherScreen;
import defense.common.tile.TileRadarStation;
import java.util.List;
import java.util.Random;
import mekanism.common.Tier;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMachine
extends BlockBase {
    public BlockMachine() {
        super("machine", Material.field_151573_f);
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onAdded();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onPlace();
        }
    }

    public static boolean canBePlacedAt(World world, int x, int y, int z, int m, int side) {
        ForgeDirection d = MekanismUtils.getRight((int)side);
        if (m == MachineData.LauncherBase.ordinal()) {
            for (int yp = 0; yp <= 2; ++yp) {
                Block b = world.func_147439_a(x + d.offsetX, y + yp, z + d.offsetZ);
                if (!b.isReplaceable((IBlockAccess)world, x + d.offsetX, y + yp, z + d.offsetZ)) {
                    return false;
                }
                if (b.isReplaceable((IBlockAccess)world, x - d.offsetX, y + yp, z - d.offsetZ)) continue;
                return false;
            }
            return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
        }
        if (m == MachineData.LauncherFrame.ordinal()) {
            return world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() && world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z) && world.func_147437_c(x, y + 2, z);
        }
        if (m == MachineData.EmpTower.ordinal()) {
            return world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z);
        }
        return world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a();
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int direction = 0;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityBasicBlock) {
            direction = ((TileEntityBasicBlock)tileEntity).facing;
        }
        return BlockMachine.canBePlacedAt(world, x, y, z, world.func_72805_g(x, y, z), direction);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
        }
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().func_77973_b() == DefenseTechItems.itemLaserDesignator) {
                return false;
            }
            if (player.field_71071_by.func_70448_g().func_77973_b() == DefenseTechItems.itemRadarGun) {
                return false;
            }
        }
        if ((tileEntity = world.func_147438_o(x, y, z)) != null && tileEntity instanceof IBlockActivate) {
            return ((IBlockActivate)tileEntity).onActivated(player);
        }
        return false;
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.onMachineActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (MachineData.get(metadata) != null) {
            try {
                return MachineData.get((int)metadata).tileEntity.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return BlockRenderingHandler.ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (MachineData data : MachineData.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, data.ordinal());
            par3List.add(stack);
            if (!data.hasTier) continue;
            ItemStack tier2 = stack.func_77946_l();
            ((ItemBlockMachine)tier2.func_77973_b()).setBaseTier(tier2, Tier.BaseTier.ADVANCED);
            par3List.add(tier2);
            ItemStack tier3 = stack.func_77946_l();
            ((ItemBlockMachine)tier3.func_77973_b()).setBaseTier(tier3, Tier.BaseTier.ELITE);
            par3List.add(tier3);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        ItemStack stack = new ItemStack(DefenseTechBlocks.blockMachine, 1, world.func_72805_g(x, y, z));
        if (tileEntity instanceof ITier) {
            ((ItemBlockMachine)stack.func_77973_b()).setBaseTier(stack, Tier.BaseTier.values()[((ITier)tileEntity).getTier()]);
        }
        return stack;
    }

    @Override
    public int func_149692_a(int metadata) {
        return metadata;
    }

    public static String getJiQiMing(TileEntity tileEntity) {
        ItemStack stack = tileEntity.func_145838_q().getPickBlock(null, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, null);
        return stack.func_82833_r();
    }

    public static enum MachineData {
        LauncherBase("LauncherBase", TileLauncherBase.class, true),
        LauncherScreen("LauncherScreen", TileLauncherScreen.class, true),
        LauncherFrame("LauncherFrame", TileLauncherFrame.class, true),
        RadarStation("RadarStation", TileRadarStation.class, false),
        EmpTower("EmpTower", TileEMPTower.class, false),
        CruiseLauncher("CruiseLauncher", TileCruiseLauncher.class, false);

        public String unlocalized;
        public Class<? extends TileEntity> tileEntity;
        public boolean hasTier;

        private MachineData(String s, Class<? extends TileEntity> tile, boolean tier) {
            this.unlocalized = s;
            this.tileEntity = tile;
            this.hasTier = tier;
        }

        public static MachineData get(int id) {
            if (id < MachineData.values().length && id >= 0) {
                return MachineData.values()[id];
            }
            return null;
        }
    }
}

