/*
 * Decompiled with CFR 0.152.
 */
package defense.common.block;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.ExplosionEvent;
import defense.api.ExplosiveType;
import defense.client.render.tile.RenderBombBlock;
import defense.common.CreativeTabHandler;
import defense.common.block.BlockBase;
import defense.common.entity.EntityExplosive;
import defense.common.explosive.Explosive;
import defense.common.explosive.ExplosiveRegistry;
import defense.common.tile.TileExplosive;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import mekanism.api.Pos3D;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockExplosive
extends BlockBase {
    public final IIcon[] ICON_TOP = new IIcon[100];
    public final IIcon[] ICON_SIDE = new IIcon[100];
    public final IIcon[] ICON_BOTTOM = new IIcon[100];

    public BlockExplosive() {
        super("explosives", Material.field_151590_u);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149647_a(CreativeTabHandler.INSTANCE);
    }

    private static byte determineOrientation(World world, int x, int y, int z, EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            int rotation;
            if (MathHelper.func_76135_e((float)((float)entityLiving.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLiving.field_70161_v - (float)z)) < 2.0f) {
                double var5 = entityLiving.field_70163_u + 1.82 - (double)entityLiving.field_70129_M;
                if (var5 - (double)y > 2.0) {
                    return 1;
                }
                if ((double)y - var5 > 0.0) {
                    return 0;
                }
            }
            return (byte)((rotation = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (rotation == 1 ? 5 : (rotation == 2 ? 3 : (rotation == 3 ? 4 : 0))));
        }
        return 0;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        TileEntity tileEntity = par1IBlockAccess.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileExplosive && ((TileExplosive)tileEntity).explosiveID == Explosive.sMine.getID()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
            return;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World par1World, int x, int y, int z) {
        TileEntity tileEntity = par1World.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileExplosive && ((TileExplosive)tileEntity).explosiveID == Explosive.sMine.getID()) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + 0.2), (double)((double)z + this.field_149757_G));
        }
        return super.func_149668_a(par1World, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int explosiveID = ((TileExplosive)world.func_147438_o((int)x, (int)y, (int)z)).explosiveID = itemStack.func_77960_j();
        if (!world.field_72995_K) {
            ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(world, x, y, z, ExplosiveType.BLOCK, ExplosiveRegistry.get(explosiveID));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.isCanceled()) {
                this.func_149697_b(world, x, y, z, explosiveID, 0);
                world.func_147468_f(x, y, z);
                return;
            }
        }
        world.func_72921_c(x, y, z, MekanismUtils.getBaseOrientation((int)ForgeDirection.NORTH.ordinal(), (int)BlockExplosive.determineOrientation(world, x, y, z, entityLiving)), 2);
        if (world.func_72864_z(x, y, z)) {
            BlockExplosive.detonate(world, x, y, z, explosiveID, 0);
        }
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            Pos3D position = new Pos3D((double)x, (double)y, (double)z);
            position.translate(ForgeDirection.getOrientation((int)i), 1.0);
            Block block = position.getCoord(world.field_73011_w.field_76574_g).getBlock((IBlockAccess)world);
            if (block != Blocks.field_150480_ab && block != Blocks.field_150356_k && block != Blocks.field_150353_l) continue;
            BlockExplosive.detonate(world, x, y, z, explosiveID, 2);
        }
        if (entityLiving != null) {
            FMLLog.fine((String)(entityLiving.func_70005_c_() + " placed " + ExplosiveRegistry.get(explosiveID).getExplosiveName() + " in: " + x + ", " + y + ", " + z + "."), (Object[])new Object[0]);
        }
    }

    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        int explosiveID = ((TileExplosive)par1IBlockAccess.func_147438_o((int)x, (int)y, (int)z)).explosiveID;
        return this.func_149691_a(side, explosiveID);
    }

    public IIcon func_149691_a(int side, int explosiveID) {
        if (side == 0) {
            return this.ICON_BOTTOM[explosiveID];
        }
        if (side == 1) {
            return this.ICON_TOP[explosiveID];
        }
        return this.ICON_SIDE[explosiveID];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (Explosive zhaPin : ExplosiveRegistry.getExplosives()) {
            this.ICON_TOP[zhaPin.getID()] = this.getIcon(iconRegister, zhaPin, "_top");
            this.ICON_SIDE[zhaPin.getID()] = this.getIcon(iconRegister, zhaPin, "_side");
            this.ICON_BOTTOM[zhaPin.getID()] = this.getIcon(iconRegister, zhaPin, "_bottom");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IIconRegister iconRegister, Explosive zhaPin, String suffix) {
        String iconName = "explosive_" + zhaPin.getUnlocalizedName() + suffix;
        try {
            ResourceLocation resourcelocation = new ResourceLocation("defense", "textures/blocks/" + iconName + ".png");
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourcelocation).func_110527_b();
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            if (bufferedimage != null) {
                return iconRegister.func_94245_a("defense:" + iconName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (suffix.equals("_bottom")) {
            return iconRegister.func_94245_a("defense:explosive_bottom_" + zhaPin.getTier());
        }
        return iconRegister.func_94245_a("defense:explosive_base_" + zhaPin.getTier());
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        super.func_149726_b(par1World, x, y, z);
        par1World.func_147479_m(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int explosiveID = ((TileExplosive)world.func_147438_o((int)x, (int)y, (int)z)).explosiveID;
        if (world.func_72864_z(x, y, z)) {
            BlockExplosive.detonate(world, x, y, z, explosiveID, 0);
        } else if (block == Blocks.field_150480_ab || block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
            BlockExplosive.detonate(world, x, y, z, explosiveID, 2);
        }
    }

    public static void detonate(World world, int x, int y, int z, int explosiveID, int causeOfExplosion) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) != null && tileEntity instanceof TileExplosive) {
            ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(world, x, y, z, ExplosiveType.BLOCK, ExplosiveRegistry.get(((TileExplosive)tileEntity).explosiveID));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (!evt.isCanceled()) {
                ((TileExplosive)tileEntity).exploding = true;
                EntityExplosive eZhaDan = new EntityExplosive(world, new Pos3D((double)x, (double)y, (double)z).translate(0.5, 0.5, 0.5), ((TileExplosive)tileEntity).explosiveID, (byte)world.func_72805_g(x, y, z), ((TileExplosive)tileEntity).nbtData);
                switch (causeOfExplosion) {
                    case 2: {
                        eZhaDan.func_70015_d(100);
                    }
                }
                world.func_72838_d((Entity)eZhaDan);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_147438_o(x, y, z) != null) {
            int explosiveID = ((TileExplosive)world.func_147438_o((int)x, (int)y, (int)z)).explosiveID;
            BlockExplosive.detonate(world, x, y, z, explosiveID, 1);
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (entityPlayer.func_71045_bC() != null) {
            if (entityPlayer.func_71045_bC().func_77973_b() == Items.field_151033_d) {
                int explosiveID = ((TileExplosive)tileEntity).explosiveID;
                BlockExplosive.detonate(world, x, y, z, explosiveID, 0);
                return true;
            }
            if (MekanismUtils.hasUsableWrench((EntityPlayer)entityPlayer, (int)x, (int)y, (int)z)) {
                int change = 3;
                switch (world.func_72805_g(x, y, z)) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 1;
                        break;
                    }
                    case 1: {
                        change = 0;
                    }
                }
                world.func_72921_c(x, y, z, ForgeDirection.getOrientation((int)change).ordinal(), 3);
                world.func_147444_c(x, y, z, (Block)this);
                return true;
            }
        }
        if (tileEntity instanceof TileExplosive) {
            return ExplosiveRegistry.get(((TileExplosive)tileEntity).explosiveID).onBlockActivated(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderBombBlock.ID;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) != null) {
            int explosiveID = ((TileExplosive)world.func_147438_o((int)x, (int)y, (int)z)).explosiveID;
            return new ItemStack((Block)this, 1, explosiveID);
        }
        return null;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileExplosive && !((TileExplosive)tileEntity).exploding) {
            int explosiveID = ((TileExplosive)tileEntity).explosiveID;
            Item item = this.func_149650_a(world.func_72805_g(x, y, z), world.field_73012_v, 0);
            this.func_149642_a(world, x, y, z, new ItemStack(item, 1, explosiveID));
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Explosive explosive : ExplosiveRegistry.getExplosives()) {
            if (!explosive.hasBlockForm()) continue;
            par3List.add(new ItemStack(par1, 1, explosive.getID()));
        }
    }

    @Override
    public TileEntity func_149915_a(World var1, int meta) {
        return new TileExplosive();
    }

    public boolean func_149662_c() {
        return false;
    }
}

