/*
 * Decompiled with CFR 0.152.
 */
package defense.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.common.CreativeTabHandler;
import defense.common.base.IRedstoneProvider;
import java.util.Random;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBase
extends Block
implements ITileEntityProvider {
    protected IIcon iconTop;
    protected IIcon iconSide;
    protected IIcon iconBottom;
    protected boolean requireSidedTextures = false;

    public BlockBase(String name) {
        this(name, Material.field_151573_f);
    }

    public BlockBase(String name, Material material) {
        super(material);
        this.func_149663_c("defense:" + name);
        this.func_149658_d("defense:" + name);
        this.func_149711_c(0.6f);
        this.func_149647_a(CreativeTabHandler.INSTANCE);
        this.field_149758_A = true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        this.dropEntireInventory(world, x, y, z, par5, par6);
        super.func_149749_a(world, x, y, z, par5, par6);
        world.func_147475_p(x, y, z);
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_149696_a(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_147438_o(par2, par3, par4);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    public void dropEntireInventory(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack var7 = inventory.func_70301_a(i);
                if (var7 == null) continue;
                Random random = new Random();
                float var8 = random.nextFloat() * 0.8f + 0.1f;
                float var9 = random.nextFloat() * 0.8f + 0.1f;
                float var10 = random.nextFloat() * 0.8f + 0.1f;
                while (var7.field_77994_a > 0) {
                    int var11 = random.nextInt(21) + 10;
                    if (var11 > var7.field_77994_a) {
                        var11 = var7.field_77994_a;
                    }
                    var7.field_77994_a -= var11;
                    EntityItem var12 = new EntityItem(world, (double)((float)x + var8), (double)((float)y + var9), (double)((float)z + var10), new ItemStack(var7.func_77973_b(), var11, var7.func_77960_j()));
                    if (var7.func_77942_o()) {
                        var12.func_92059_d().func_77982_d((NBTTagCompound)var7.func_77978_p().func_74737_b());
                    }
                    float var13 = 0.05f;
                    var12.field_70159_w = (float)random.nextGaussian() * var13;
                    var12.field_70181_x = (float)random.nextGaussian() * var13 + 0.2f;
                    var12.field_70179_y = (float)random.nextGaussian() * var13;
                    world.func_72838_d((Entity)var12);
                    if (var7.field_77994_a > 0) continue;
                    inventory.func_70299_a(i, null);
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        ItemStack tool = entityPlayer.field_71071_by.func_70448_g();
        int metadata = world.func_72805_g(x, y, z);
        if (MekanismUtils.hasUsableWrench((EntityPlayer)entityPlayer, (int)x, (int)y, (int)z)) {
            if (MekanismUtils.isBCWrench((Item)tool.func_77973_b())) {
                ((IToolWrench)tool.func_77973_b()).wrenchUsed(entityPlayer, x, y, z);
            }
            if (entityPlayer.func_70093_af() && this.onSneakUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
                return true;
            }
            return this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
        }
        if (entityPlayer.func_70093_af() && this.onSneakMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
            return true;
        }
        return this.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        if (this.requireSidedTextures) {
            this.iconTop = iconRegister.func_94245_a(this.func_149739_a().replace("tile.", "") + "_top");
            this.iconSide = iconRegister.func_94245_a(this.func_149739_a().replace("tile.", "") + "_side");
            this.iconBottom = iconRegister.func_94245_a(this.func_149739_a().replace("tile.", "") + "_bottom");
        }
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = par1IBlockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof IRedstoneProvider) {
            return ((IRedstoneProvider)tileEntity).isPoweringTo(ForgeDirection.getOrientation((int)side)) ? 15 : 0;
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = par1IBlockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof IRedstoneProvider) {
            return ((IRedstoneProvider)tileEntity).isIndirectlyPoweringTo(ForgeDirection.getOrientation((int)side)) ? 15 : 0;
        }
        return 0;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return null;
    }
}

