/*
 * Decompiled with CFR 0.152.
 */
package defense.api;

import defense.common.Vector2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public class RadarRegistry {
    private static Set<TileEntity> detectableTileEntities = new HashSet<TileEntity>();
    private static Set<Entity> detectableEntities = new HashSet<Entity>();

    public static void register(TileEntity tileEntity) {
        if (!detectableTileEntities.contains(tileEntity)) {
            detectableTileEntities.add(tileEntity);
        }
    }

    public static void unregister(TileEntity tileEntity) {
        if (detectableTileEntities.contains(tileEntity)) {
            detectableTileEntities.remove(tileEntity);
        }
    }

    public static void register(Entity entity) {
        if (!detectableEntities.contains(entity)) {
            detectableEntities.add(entity);
        }
    }

    public static void unregister(Entity entity) {
        if (detectableEntities.contains(entity)) {
            detectableEntities.remove(entity);
        }
    }

    public static List<TileEntity> getTileEntitiesInArea(Vector2 minVector, Vector2 maxVector) {
        RadarRegistry.cleanUpArray();
        ArrayList<TileEntity> returnArray = new ArrayList<TileEntity>();
        for (TileEntity tileEntity : detectableTileEntities) {
            Vector2 point = new Vector2(new Pos3D(tileEntity));
            if (!(point.x > minVector.x) || !(point.x < maxVector.x) || !(point.y > minVector.y) || !(point.y < maxVector.y)) continue;
            returnArray.add(tileEntity);
        }
        return returnArray;
    }

    public static List<Entity> getEntitiesWithinRadius(Vector2 vector, int radius) {
        RadarRegistry.cleanUpArray();
        ArrayList<Entity> returnArray = new ArrayList<Entity>();
        for (Entity entity : detectableEntities) {
            Vector2 vector2 = new Vector2(new Pos3D(entity));
            if (!(Vector2.distance(vector, vector2) <= (double)radius)) continue;
            returnArray.add(entity);
        }
        return returnArray;
    }

    public static Set<TileEntity> getTileEntities() {
        RadarRegistry.cleanUpArray();
        return detectableTileEntities;
    }

    public static Set<Entity> getEntities() {
        RadarRegistry.cleanUpArray();
        return detectableEntities;
    }

    public static void cleanUpArray() {
        try {
            Iterator<TileEntity> it = detectableTileEntities.iterator();
            while (it.hasNext()) {
                TileEntity tileEntity = it.next();
                if (tileEntity == null) {
                    it.remove();
                    continue;
                }
                if (tileEntity.func_145837_r()) {
                    it.remove();
                    continue;
                }
                if (tileEntity.func_145831_w().func_147438_o(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e) == tileEntity) continue;
                it.remove();
            }
            Iterator<Entity> it2 = detectableEntities.iterator();
            while (it2.hasNext()) {
                Entity entity = it2.next();
                if (entity == null) {
                    it2.remove();
                    continue;
                }
                if (!entity.field_70128_L) continue;
                it2.remove();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to clean up radar list properly.");
            e.printStackTrace();
        }
    }
}

