/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.WeightedRandomNBTTag;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.world.WorldGenDungeon;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.DungeonHooks;
import org.apache.logging.log4j.Logger;

public class DungeonParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        Object object;
        ArrayList<WeightedRandomNBTTag> arrayList = new ArrayList<WeightedRandomNBTTag>();
        if (jsonObject.has("spawnEntity")) {
            if (!FeatureParser.parseEntityList(jsonObject.get("spawnEntity"), arrayList)) {
                logger.warn("Entry specifies invalid entity list for 'dungeon' generator! Using 'Pig'!");
                arrayList.clear();
                object = new NBTTagCompound();
                object.func_74778_a("EntityId", "Pig");
                arrayList.add(new WeightedRandomNBTTag(100, (NBTBase)object));
            }
        } else {
            logger.warn("Entry specifies invalid entity list for 'dungeon' generator! Using 'Pig'!");
            object = new NBTTagCompound();
            object.func_74778_a("EntityId", "Pig");
            arrayList.add(new WeightedRandomNBTTag(100, (NBTBase)object));
        }
        object = new WorldGenDungeon(list, list2, arrayList);
        if (jsonObject.has("spawnerFloor")) {
            list = new ArrayList<WeightedRandomBlock>();
            if (FeatureParser.parseResList(jsonObject.get("spawnerFloor"), list, true)) {
                object.floor = list;
            } else {
                logger.warn("Entry specifies invalid block list for 'spawnerFloor'! Using walls.");
            }
        }
        if (jsonObject.has("lootTable")) {
            ArrayList<DungeonHooks.DungeonMob> arrayList2 = new ArrayList<DungeonHooks.DungeonMob>();
            if (FeatureParser.parseWeightedStringList(jsonObject.get("lootTable"), arrayList2)) {
                object.lootTables = arrayList2;
            } else {
                logger.warn("Entry specifies invalid string list for 'lootTable'! Using default.");
            }
        }
        if (jsonObject.has("maxChests")) {
            object.maxChests = jsonObject.get("maxChests").getAsInt();
        }
        if (jsonObject.has("chestAttempts")) {
            object.maxChestTries = MathHelper.clamp(jsonObject.get("chestAttempts").getAsInt(), 1, 5);
        }
        if (jsonObject.has("minHoles")) {
            object.minHoles = jsonObject.get("minHoles").getAsInt();
        }
        if (jsonObject.has("maxHoles")) {
            object.maxHoles = jsonObject.get("maxHoles").getAsInt();
        }
        if (jsonObject.has("minHeight")) {
            object.minHeight = jsonObject.get("minHeight").getAsInt();
        }
        if (jsonObject.has("maxHeight")) {
            object.maxHeight = jsonObject.get("maxHeight").getAsInt();
        }
        if (jsonObject.has("minWidthX")) {
            object.minWidthX = jsonObject.get("minWidthX").getAsInt();
        }
        if (jsonObject.has("maxWidthX")) {
            object.maxWidthX = jsonObject.get("maxWidthX").getAsInt();
        }
        if (jsonObject.has("minWidthZ")) {
            object.minWidthZ = jsonObject.get("minWidthZ").getAsInt();
        }
        if (jsonObject.has("maxWidthZ")) {
            object.maxWidthZ = jsonObject.get("maxWidthZ").getAsInt();
        }
        return object;
    }
}

