/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.random;

import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.List;
import java.util.Random;
import java.util.function.ToDoubleFunction;

public class WeightedShuffler {
    public static <T extends WeightedSelector.Item> void shuffleItems(Random rand, List<T> items) {
        WeightedShuffler.shuffleItems(rand, items, WeightedSelector.totalWeight(items));
    }

    public static <T extends WeightedSelector.Item> void shuffleItems(Random rand, List<T> items, double totalWeight) {
        int size = items.size();
        for (int shuffled = 0; shuffled < size - 1; ++shuffled) {
            List<T> subList = items.subList(shuffled, size);
            T selected = totalWeight > 0.0 ? WeightedSelector.selectItem(rand, subList, totalWeight, true) : (WeightedSelector.Item)subList.get(rand.nextInt(subList.size()));
            totalWeight -= selected.getWeight();
            subList.add(0, selected);
        }
    }

    public static <T> void shuffle(Random rand, List<T> items, ToDoubleFunction<T> weightFunction) {
        WeightedShuffler.shuffle(rand, items, weightFunction, WeightedSelector.totalWeight(items, weightFunction));
    }

    public static <T> void shuffle(Random rand, List<T> items, ToDoubleFunction<T> weightFunction, double totalWeight) {
        int size = items.size();
        for (int shuffled = 0; shuffled < size - 1; ++shuffled) {
            List<T> subList = items.subList(shuffled, size);
            T selected = totalWeight > 0.0 ? WeightedSelector.select(rand, subList, weightFunction, totalWeight, true) : subList.get(rand.nextInt(subList.size()));
            totalWeight -= weightFunction.applyAsDouble(selected);
            subList.add(0, selected);
        }
    }
}

