/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class IvBlockMultiblock
extends BlockContainer {
    protected IvBlockMultiblock(Material par2Material) {
        super(par2Material);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int blockMeta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IvTileEntityMultiBlock) {
            IvTileEntityMultiBlock tileEntityMultiBlock = (IvTileEntityMultiBlock)tileEntity;
            if (!tileEntityMultiBlock.multiblockInvalid) {
                tileEntityMultiBlock.multiblockInvalid = true;
                if (tileEntityMultiBlock.isParent()) {
                    this.destroyChildrenOf(world, x, y, z, block, blockMeta, tileEntityMultiBlock);
                } else {
                    this.destroyParentOf(tileEntityMultiBlock);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, blockMeta);
    }

    public void destroyChildrenOf(World world, int x, int y, int z, Block block, int blockMeta, IvTileEntityMultiBlock tileEntityMultiBlock) {
        if (!world.field_72995_K) {
            this.parentBlockDropItemContents(world, tileEntityMultiBlock, x, y, z, block, blockMeta);
        }
        int[][] toDestroy = tileEntityMultiBlock.getActiveChildCoords();
        TileEntity[] destroyTEs = new TileEntity[toDestroy.length];
        for (int i = 0; i < toDestroy.length; ++i) {
            int[] coords = toDestroy[i];
            TileEntity otherTE = world.func_147438_o(coords[0], coords[1], coords[2]);
            if (!(otherTE instanceof IvTileEntityMultiBlock) || ((IvTileEntityMultiBlock)otherTE).multiblockInvalid) continue;
            destroyTEs[i] = otherTE;
            ((IvTileEntityMultiBlock)otherTE).multiblockInvalid = true;
        }
        for (TileEntity destroyTE : destroyTEs) {
            if (destroyTE == null) continue;
            this.triggerBlockDestroyEffects(world, destroyTE.field_145851_c, destroyTE.field_145848_d, destroyTE.field_145849_e);
            world.func_147468_f(destroyTE.field_145851_c, destroyTE.field_145848_d, destroyTE.field_145849_e);
        }
    }

    protected void triggerBlockDestroyEffects(World world, int x, int y, int z) {
        world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)this) + (world.func_72805_g(x, y, z) << 12));
    }

    public void destroyParentOf(IvTileEntityMultiBlock tileEntityMultiBlock) {
        int[] parentTECoords;
        World world = tileEntityMultiBlock.func_145831_w();
        TileEntity parentTE = world.func_147438_o((parentTECoords = tileEntityMultiBlock.getActiveParentCoords())[0], parentTECoords[1], parentTECoords[2]);
        if (parentTE instanceof IvTileEntityMultiBlock && !((IvTileEntityMultiBlock)parentTE).multiblockInvalid) {
            this.triggerBlockDestroyEffects(world, parentTE.field_145851_c, parentTE.field_145848_d, parentTE.field_145849_e);
            world.func_147468_f(parentTE.field_145851_c, parentTE.field_145848_d, parentTE.field_145849_e);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        IvTileEntityMultiBlock tileEntityMultiBlock = IvBlockMultiblock.getValidatedTotalParent((Block)this, (IBlockAccess)world, x, y, z);
        if (tileEntityMultiBlock != null && !world.field_72995_K && willHarvest) {
            this.parentBlockHarvestItem(world, tileEntityMultiBlock, x, y, z, (Block)this, world.func_72805_g(x, y, z));
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        IvTileEntityMultiBlock tileEntityMultiBlock = IvBlockMultiblock.getValidatedTotalParent((Block)this, (IBlockAccess)world, x, y, z);
        if (tileEntityMultiBlock != null && !world.field_72995_K) {
            this.parentBlockHarvestItem(world, tileEntityMultiBlock, x, y, z, (Block)this, world.func_72805_g(x, y, z));
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public void parentBlockDropItemContents(World world, IvTileEntityMultiBlock tileEntity, int x, int y, int z, Block block, int metadata) {
    }

    public void parentBlockHarvestItem(World world, IvTileEntityMultiBlock tileEntity, int x, int y, int z, Block block, int metadata) {
    }

    public void func_149690_a(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
    }

    public static boolean validateMultiblock(Block block, IBlockAccess access, int x, int y, int z) {
        if (access.func_147439_a(x, y, z) != block) {
            return false;
        }
        boolean isValidChild = false;
        boolean destroy = false;
        TileEntity tileEntity = access.func_147438_o(x, y, z);
        if (tileEntity instanceof IvTileEntityMultiBlock) {
            IvTileEntityMultiBlock tileEntityMultiBlock = (IvTileEntityMultiBlock)tileEntity;
            IvTileEntityMultiBlock parent = tileEntityMultiBlock.getParent();
            isValidChild = tileEntityMultiBlock.isParent() || parent != null && parent.isParent();
            boolean bl = destroy = !isValidChild && !tileEntityMultiBlock.multiblockInvalid;
        }
        if (destroy && access instanceof World) {
            ((World)access).func_147468_f(x, y, z);
        }
        return isValidChild;
    }

    public static IvTileEntityMultiBlock getValidatedIfParent(Block block, World world, int x, int y, int z) {
        if (IvBlockMultiblock.validateMultiblock(block, (IBlockAccess)world, x, y, z)) {
            IvTileEntityMultiBlock tileEntity = (IvTileEntityMultiBlock)world.func_147438_o(x, y, z);
            return tileEntity.isParent() ? tileEntity : null;
        }
        return null;
    }

    public static IvTileEntityMultiBlock getValidatedTotalParent(Block block, IBlockAccess access, int x, int y, int z) {
        TileEntity tileEntity;
        if (IvBlockMultiblock.validateMultiblock(block, access, x, y, z) && (tileEntity = access.func_147438_o(x, y, z)) instanceof IvTileEntityMultiBlock) {
            return ((IvTileEntityMultiBlock)tileEntity).getTotalParent();
        }
        return null;
    }
}

