/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import ivorius.reccomplex.structures.generic.matchers.DimensionMatcher;
import ivorius.reccomplex.utils.CustomizableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.commons.lang3.tuple.Pair;

public class StructureSelector {
    public static final int STRUCTURE_MIN_CAP_DEFAULT = 20;
    private static CustomizableMap<String, Category> categories = new CustomizableMap();
    private Multimap<String, WeightedSelector.SimpleItem<Pair<StructureInfo, NaturalGenerationInfo>>> weightedStructureInfos = ArrayListMultimap.create();
    private final Set<String> cachedDimensionTypes = new HashSet<String>();

    public StructureSelector(Collection<StructureInfo> structures, BiomeGenBase biome, WorldProvider provider) {
        this.cachedDimensionTypes.addAll(DimensionDictionary.getDimensionTypes(provider));
        for (StructureInfo structureInfo : structures) {
            List<NaturalGenerationInfo> generationInfos = structureInfo.generationInfos(NaturalGenerationInfo.class);
            for (NaturalGenerationInfo naturalGenerationInfo : generationInfos) {
                double generationWeight = naturalGenerationInfo.getGenerationWeight(biome, provider);
                if (!(generationWeight > 0.0)) continue;
                this.weightedStructureInfos.put((Object)naturalGenerationInfo.generationCategory, (Object)new WeightedSelector.SimpleItem(generationWeight, (Object)Pair.of((Object)structureInfo, (Object)naturalGenerationInfo)));
            }
        }
    }

    public static void registerCategory(String id, Category category, boolean custom) {
        categories.put(id, category, custom);
    }

    public static void unregisterCategory(String id, boolean custom) {
        categories.remove(id, custom);
    }

    public static void clearCustom() {
        categories.clearCustom();
    }

    public static Category categoryForID(String id) {
        return categories.getMap().get(id);
    }

    public static Set<String> allCategoryIDs() {
        return categories.getMap().keySet();
    }

    public boolean isValid(BiomeGenBase biome, WorldProvider provider) {
        return DimensionDictionary.getDimensionTypes(provider).equals(this.cachedDimensionTypes);
    }

    public float generationChance(String category, BiomeGenBase biome, WorldProvider worldProvider) {
        Category categoryObj = StructureSelector.categoryForID(category);
        if (categoryObj != null) {
            return categoryObj.structureSpawnChance(biome, worldProvider, this.weightedStructureInfos.get((Object)category).size()) * RCConfig.structureSpawnChanceModifier;
        }
        return 0.0f;
    }

    public List<Pair<StructureInfo, NaturalGenerationInfo>> generatedStructures(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<Pair<StructureInfo, NaturalGenerationInfo>> infos = new ArrayList<Pair<StructureInfo, NaturalGenerationInfo>>();
        BiomeGenBase biome = world.func_72807_a(chunkX * 16, chunkZ * 16);
        this.weightedStructureInfos.keySet().stream().filter(category -> random.nextFloat() < this.generationChance((String)category, biome, world.field_73011_w)).forEach(category -> infos.add((Pair<StructureInfo, NaturalGenerationInfo>)WeightedSelector.select((Random)random, (Collection)this.weightedStructureInfos.get(category))));
        return infos;
    }

    public static class GenerationInfo {
        @SerializedName(value="spawnChance")
        public float spawnChance;
        @SerializedName(value="biomeMatcher")
        public BiomeMatcher biomeMatcher;
        @SerializedName(value="dimensionMatcher")
        public DimensionMatcher dimensionMatcher;

        public GenerationInfo(float spawnChance, BiomeMatcher biomeMatcher, DimensionMatcher dimensionMatcher) {
            this.spawnChance = spawnChance;
            this.biomeMatcher = biomeMatcher;
            this.dimensionMatcher = dimensionMatcher;
        }
    }

    public static class SimpleCategory
    implements Category {
        @SerializedName(value="defaultSpawnChance")
        public float defaultSpawnChance;
        @SerializedName(value="generationInfos")
        public final List<GenerationInfo> generationInfos = new ArrayList<GenerationInfo>();
        @SerializedName(value="selectableInGUI")
        public boolean selectableInGUI;
        @SerializedName(value="structureMinCap")
        public Integer structureMinCap;
        @SerializedName(value="title")
        public String title;
        @SerializedName(value="tooltip")
        public final List<String> tooltip = new ArrayList<String>();

        public SimpleCategory(float defaultSpawnChance, List<GenerationInfo> generationInfos, boolean selectableInGUI, Integer structureMinCap) {
            this.defaultSpawnChance = defaultSpawnChance;
            this.generationInfos.addAll(generationInfos);
            this.selectableInGUI = selectableInGUI;
            this.structureMinCap = structureMinCap;
        }

        public SimpleCategory(float defaultSpawnChance, List<GenerationInfo> generationInfos, boolean selectableInGUI) {
            this(defaultSpawnChance, generationInfos, selectableInGUI, null);
        }

        @Override
        public float structureSpawnChance(BiomeGenBase biome, WorldProvider worldProvider, int registeredStructures) {
            float amountMultiplier = Math.min((float)registeredStructures / (float)this.getActiveStructureMinCap().intValue(), 1.0f);
            for (GenerationInfo info : this.generationInfos) {
                if (!info.biomeMatcher.apply(biome) || !info.dimensionMatcher.apply(worldProvider)) continue;
                return info.spawnChance * amountMultiplier;
            }
            return this.defaultSpawnChance * amountMultiplier;
        }

        public Integer getActiveStructureMinCap() {
            return this.structureMinCap != null ? this.structureMinCap : 20;
        }

        @Override
        public boolean selectableInGUI() {
            return this.selectableInGUI;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public List<String> tooltip() {
            return this.tooltip;
        }
    }

    public static interface Category {
        public float structureSpawnChance(BiomeGenBase var1, WorldProvider var2, int var3);

        public boolean selectableInGUI();

        public String title();

        public List<String> tooltip();
    }
}

