/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.files.FileTypeHandler;
import ivorius.reccomplex.worldgen.StructureSelector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;

public class CategoryLoader
implements FileTypeHandler {
    public static final String FILE_SUFFIX = "rcnc";
    private Gson gson = CategoryLoader.createGson();

    public static Gson createGson() {
        return new GsonBuilder().create();
    }

    @Override
    public boolean loadFile(Path path, FileLoadContext context) {
        StructureSelector.SimpleCategory category = null;
        String name = context.customID != null ? context.customID : FilenameUtils.getBaseName((String)path.getFileName().toString());
        try {
            category = this.read(new String(Files.readAllBytes(path)));
        }
        catch (IOException e) {
            RecurrentComplex.logger.warn("Error reading natural spawn category", (Throwable)e);
        }
        if (category != null) {
            StructureSelector.registerCategory(name, category, context.custom);
            return true;
        }
        return false;
    }

    @Override
    public void clearCustomFiles() {
        StructureSelector.clearCustom();
    }

    public StructureSelector.SimpleCategory read(String file) {
        return (StructureSelector.SimpleCategory)this.gson.fromJson(file, StructureSelector.SimpleCategory.class);
    }
}

