/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.ivtoolkit.tools.Visitor;
import ivorius.reccomplex.utils.Algebra;
import ivorius.reccomplex.utils.ExpressionCache;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumChatFormatting;

public class PrefixedTypeExpressionCache<T>
extends ExpressionCache<T> {
    protected final SortedSet<VariableType<T>> types = new TreeSet<VariableType<T>>();

    public PrefixedTypeExpressionCache(Algebra<T> algebra, String expression) {
        super(algebra, expression);
    }

    public PrefixedTypeExpressionCache(Algebra<T> algebra, T emptyResult, String emptyResultRepresentation, String expression) {
        super(algebra, emptyResult, emptyResultRepresentation, expression);
    }

    public void addType(VariableType<T> type) {
        this.types.add(type);
    }

    public void removeType(VariableType<T> type) {
        this.types.remove(type);
    }

    public SortedSet<VariableType<T>> types() {
        return Collections.unmodifiableSortedSet(this.types);
    }

    protected VariableType<T> type(String var) {
        return this.types.stream().filter(input -> var.startsWith(input.prefix)).findFirst().orElseGet(() -> null);
    }

    protected boolean isKnownVariable(String var, Object ... args) {
        VariableType<T> type = this.type(var);
        return type != null && type.isKnown(var.substring(type.prefix.length()), args);
    }

    protected T evaluateVariable(String var, Object ... args) {
        VariableType<T> type = this.type(var);
        return type != null ? (T)type.evaluate(var.substring(type.prefix.length()), args) : null;
    }

    @Override
    public boolean containsUnknownVariables() {
        return this.containsUnknownVariables(new Object[0]);
    }

    protected boolean containsUnknownVariables(Object ... args) {
        return this.parsedExpression != null && !this.parsedExpression.walkVariables((Visitor<String>)((Visitor)s -> this.isKnownVariable((String)s, args)));
    }

    protected T evaluate(Object ... args) {
        return (T)(this.parsedExpression != null ? this.parsedExpression.evaluate((String var) -> this.evaluateVariable((String)var, args)) : null);
    }

    @Override
    @Nonnull
    public String getDisplayString() {
        return this.getDisplayString(new Object[0]);
    }

    @Nonnull
    public String getDisplayString(Object ... args) {
        return this.parsedExpression != null ? this.parsedExpression.toString(input -> {
            VariableType<T> type = this.type((String)input);
            return type != null ? type.getRepresentation(input.substring(type.prefix.length()), args) : EnumChatFormatting.RED + input;
        }) : EnumChatFormatting.RED + this.expression;
    }

    public static abstract class VariableType<T>
    implements Comparable<VariableType> {
        protected String prefix;

        public VariableType(String prefix) {
            this.prefix = prefix;
        }

        public abstract T evaluate(String var1, Object ... var2);

        public abstract boolean isKnown(String var1, Object ... var2);

        public abstract String getRepresentation(String var1, Object ... var2);

        @Override
        public int compareTo(@Nonnull VariableType o) {
            return o.prefix.compareTo(this.prefix);
        }
    }
}

