/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.reccomplex.utils.Algebra;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpressionCache<T> {
    @Nonnull
    protected Algebra<T> algebra;
    protected T emptyExpressionResult;
    protected String emptyResultRepresentation;
    @Nonnull
    protected String expression;
    @Nullable
    protected Algebra.Expression<T> parsedExpression;
    @Nullable
    protected ParseException parseException;

    public ExpressionCache(@Nonnull Algebra<T> algebra, String expression) {
        this.algebra = algebra;
        this.setExpression(expression);
    }

    public ExpressionCache(@Nonnull Algebra<T> algebra, T emptyExpressionResult, String emptyResultRepresentation, String expression) {
        this.algebra = algebra;
        this.emptyExpressionResult = emptyExpressionResult;
        this.emptyResultRepresentation = emptyResultRepresentation;
        this.setExpression(expression);
    }

    protected void parseExpression() {
        if (this.expressionIsEmpty() && this.acceptsEmptyExpression()) {
            this.parsedExpression = new Algebra.Value<T>(this.emptyExpressionResult, this.emptyResultRepresentation);
            this.parseException = null;
        } else {
            try {
                this.parsedExpression = this.algebra.parse(this.expression);
                this.parseException = null;
            }
            catch (ParseException e) {
                this.parsedExpression = null;
                this.parseException = e;
            }
        }
    }

    @Nonnull
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(@Nonnull String expression) {
        this.expression = expression;
        this.parseExpression();
    }

    @Nonnull
    public Algebra<T> getAlgebra() {
        return this.algebra;
    }

    public void setAlgebra(@Nonnull Algebra<T> algebra) {
        this.algebra = algebra;
    }

    public T getEmptyExpressionResult() {
        return this.emptyExpressionResult;
    }

    public String getEmptyExpressionResultRepresentation() {
        return this.emptyResultRepresentation;
    }

    public void setNoEmptyExpressionResult() {
        this.emptyExpressionResult = null;
        this.emptyResultRepresentation = null;
        this.parseExpression();
    }

    public void setEmptyExpressionResult(T emptyResult, String representation) {
        this.emptyExpressionResult = emptyResult;
        this.emptyResultRepresentation = representation;
        this.parseExpression();
    }

    public boolean acceptsEmptyExpression() {
        return this.emptyResultRepresentation != null;
    }

    public boolean expressionIsEmpty() {
        return this.expression.trim().isEmpty();
    }

    @Nonnull
    public String getDisplayString() {
        return this.getExpression();
    }

    @Nullable
    public Algebra.Expression<T> getParsedExpression() {
        return this.parsedExpression;
    }

    @Nullable
    public ParseException getParseException() {
        return this.parseException;
    }

    public boolean isExpressionValid() {
        return this.parsedExpression != null && this.parseException == null;
    }

    public boolean containsUnknownVariables() {
        return false;
    }
}

