/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.SimpleConnectors;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ConnectorFactory {
    public static final String MALE_PREFIX = "Male:";
    public static final String FEMALE_PREFIX = "Female:";
    private final Map<String, Connector> connectors = new HashMap<String, Connector>();

    public Connector get(String id) {
        Connector connector = this.connectors.get(id);
        return connector != null ? connector : this.register(id);
    }

    public Connector register(String id) {
        Connector gendered = this.tryCreateGendered(id);
        if (gendered != null) {
            return gendered;
        }
        SimpleConnectors.Hermaphrodite hermaphrodite = new SimpleConnectors.Hermaphrodite(id);
        this.connectors.put(id, hermaphrodite);
        return hermaphrodite;
    }

    public void put(String id, Connector connector) {
        this.connectors.put(id, connector);
    }

    protected Connector tryCreateGendered(String id) {
        String baseID = ConnectorFactory.fromPrefix(MALE_PREFIX, id);
        if (baseID != null) {
            return this.createGendered(true, baseID);
        }
        baseID = ConnectorFactory.fromPrefix(FEMALE_PREFIX, id);
        if (baseID != null) {
            return this.createGendered(false, baseID);
        }
        return null;
    }

    protected Connector createGendered(boolean returnMale, String baseID) {
        String male = MALE_PREFIX + baseID;
        String female = FEMALE_PREFIX + baseID;
        Pair<SimpleConnectors.Gendered, SimpleConnectors.Gendered> gendered = SimpleConnectors.Gendered.create(male, female);
        this.connectors.put(male, (Connector)gendered.getLeft());
        this.connectors.put(female, (Connector)gendered.getRight());
        return returnMale ? (Connector)gendered.getLeft() : (Connector)gendered.getRight();
    }

    private static String fromPrefix(String prefix, String id) {
        return id.startsWith(prefix) ? id.substring(prefix.length()) : null;
    }
}

