/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.gentypes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceMazeGenerationInfo;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.Selection;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.SavedMazeReachability;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.util.StatCollector;

public class MazeGenerationInfo
extends StructureGenerationInfo {
    private static Gson gson = MazeGenerationInfo.createGson();
    public String id = "";
    public String mazeID;
    public SavedMazeComponent mazeComponent;

    public MazeGenerationInfo() {
        this(MazeGenerationInfo.randomID("Maze"), "", new SavedMazeComponent(null, "Wall"));
        this.mazeComponent.rooms.addAll(Selection.zeroSelection(3));
    }

    public MazeGenerationInfo(String id, String mazeID, SavedMazeComponent mazeComponent) {
        this.id = id;
        this.mazeID = mazeID;
        this.mazeComponent = mazeComponent;
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(MazeGenerationInfo.class, (Object)new Serializer());
        builder.registerTypeAdapter(SavedMazeComponent.class, (Object)new SavedMazeComponent.Serializer());
        builder.registerTypeAdapter(MazeRoom.class, (Object)new SavedMazeComponent.RoomSerializer());
        builder.registerTypeAdapter(SavedMazeReachability.class, (Object)new SavedMazeReachability.Serializer());
        builder.registerTypeAdapter(SavedMazePath.class, (Object)new SavedMazePath.Serializer());
        builder.registerTypeAdapter(SavedMazePathConnection.class, (Object)new SavedMazePathConnection.Serializer());
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    @Override
    public String displayString() {
        return StatCollector.func_74837_a((String)"reccomplex.generationInfo.mazeComponent.title", (Object[])new Object[]{this.mazeID});
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceMazeGenerationInfo(navigator, delegate, this);
    }

    public static class Serializer
    implements JsonSerializer<MazeGenerationInfo>,
    JsonDeserializer<MazeGenerationInfo> {
        public MazeGenerationInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeGenerationInfo");
            String id = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "id", "");
            String mazeID = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "mazeID");
            SavedMazeComponent mazeComponent = (SavedMazeComponent)gson.fromJson(jsonObject.get("component"), SavedMazeComponent.class);
            return new MazeGenerationInfo(id, mazeID, mazeComponent);
        }

        public JsonElement serialize(MazeGenerationInfo src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            jsonObject.addProperty("mazeID", src.mazeID);
            jsonObject.add("component", gson.toJsonTree((Object)src.mazeComponent));
            return jsonObject;
        }
    }
}

