/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.scripts.world;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.blocks.SpawnCommandLogic;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.command.TableDataSourceWorldScriptCommand;
import ivorius.reccomplex.scripts.world.WorldScript;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.NBTNone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class WorldScriptCommand
implements WorldScript<NBTNone> {
    public List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<Entry> entries) {
        IvCollections.setContentsOfList(this.entries, entries);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.entries.clear();
        NBTTagList entryNBTs = nbtTagCompound.func_150295_c("commands", 10);
        for (int i = 0; i < entryNBTs.func_74745_c(); ++i) {
            this.entries.add(new Entry(entryNBTs.func_150305_b(i)));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList structureNBTList = new NBTTagList();
        for (Entry entry : this.entries) {
            structureNBTList.func_74742_a((NBTBase)entry.writeToNBT());
        }
        nbtTagCompound.func_74782_a("commands", (NBTBase)structureNBTList);
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, BlockCoord coord, World world) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public void generate(StructureSpawnContext context, NBTNone instanceData, BlockCoord coord) {
        if (context.includes(coord) && this.entries.size() > 0) {
            Entry entry = (Entry)WeightedSelector.selectItem((Random)context.random, this.entries);
            SpawnCommandLogic logic = new SpawnCommandLogic(context.world, coord, entry.command);
            try {
                logic.executeCommand(context.world);
            }
            catch (Throwable t) {
                RecurrentComplex.logger.error("Error executing command '%s'", new Object[]{entry.command});
                RecurrentComplex.logger.error("Command execution failed", t);
            }
        }
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.command");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptCommand(this, tableDelegate, navigator);
    }

    public static class Entry
    implements WeightedSelector.Item {
        public String command;
        public Double weight;

        public Entry(Double weight, String command) {
            this.command = command;
            this.weight = weight;
        }

        public Entry(NBTTagCompound compound) {
            this.command = compound.func_74779_i("command");
            this.weight = compound.func_150297_b("weight", 6) ? Double.valueOf(compound.func_74769_h("weight")) : (compound.func_150297_b("weight", 3) ? Double.valueOf((double)compound.func_74762_e("weight") * 0.01) : null);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("command", this.command);
            if (this.weight != null) {
                compound.func_74780_a("weight", this.weight.doubleValue());
            }
            return compound;
        }

        public double getWeight() {
            return this.weight != null ? this.weight : 1.0;
        }

        public boolean hasDefaultWeight() {
            return this.weight == null;
        }
    }
}

