/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.structures.registry.MCRegistrySpecial;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    private MCRegistrySpecial registry;

    public ItemStackSerializer(MCRegistrySpecial registry) {
        this.registry = registry;
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", this.registry.itemHidingMode().containedItemID(src));
        jsonObject.addProperty("damage", (Number)src.func_77960_j());
        jsonObject.addProperty("count", (Number)src.field_77994_a);
        if (src.func_77942_o()) {
            jsonObject.add("tag", context.serialize((Object)src.func_77978_p()));
        }
        return jsonObject;
    }

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "ItemStack");
        String id = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "id");
        int damage = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "damage");
        int count = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "count");
        ItemStack stack = this.registry.itemHidingMode().constructItemStack(id, count, damage);
        if (jsonObject.has("tag")) {
            NBTTagCompound compound = (NBTTagCompound)context.deserialize(jsonObject.get("tag"), NBTTagCompound.class);
            stack.func_77982_d(compound);
        } else if (jsonObject.has("tagBase64")) {
            NBTTagCompound compound = NbtToJson.getNBTFromBase64(JsonUtils.getJsonObjectStringFieldValue(jsonObject, "tagBase64"));
            stack.func_77982_d(compound);
        }
        return stack;
    }
}

