/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.items.ItemBlockSelector;
import ivorius.reccomplex.items.ItemInputHandler;
import ivorius.reccomplex.items.ItemSyncable;
import ivorius.reccomplex.network.PacketSyncItem;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemBlockSelectorFloating
extends ItemBlockSelector
implements ItemSyncable,
ItemInputHandler {
    public static final float SCROLL_DISTANCE_SPEED = 0.004f;

    public static BlockCoord getHoveredBlock(EntityLivingBase entity, float selectionRange) {
        Vec3 look = entity.func_70040_Z();
        int blockX = MathHelper.func_76128_c((double)(look.field_72450_a * (double)selectionRange + entity.field_70165_t));
        int blockY = MathHelper.func_76128_c((double)(look.field_72448_b * (double)selectionRange + entity.field_70163_u + (double)entity.func_70047_e()));
        int blockZ = MathHelper.func_76128_c((double)(look.field_72449_c * (double)selectionRange + entity.field_70161_v));
        return new BlockCoord(blockX, blockY, blockZ);
    }

    public ItemStack func_77659_a(ItemStack usedItem, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            BlockCoord position = ItemBlockSelectorFloating.getHoveredBlock((EntityLivingBase)player, this.getSelectionRange(usedItem));
            this.sendClickToServer(usedItem, world, player, position);
        }
        return usedItem;
    }

    public float getSelectionRange(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("selectionRange", 5) ? stack.func_77978_p().func_74760_g("selectionRange") : 2.0f;
    }

    public void setSelectionRange(ItemStack stack, float range) {
        stack.func_77983_a("selectionRange", (NBTBase)new NBTTagFloat(range));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        list.add(String.format("Range: %.02f", Float.valueOf(this.getSelectionRange(stack))));
        list.add("(Hold ctrl and scroll to modify range)");
        list.add("(Hold ctrl for secondary selection)");
    }

    @Override
    public void writeSyncedNBT(NBTTagCompound compound, ItemStack stack) {
        compound.func_74776_a("selectionRange", this.getSelectionRange(stack));
    }

    @Override
    public void readSyncedNBT(NBTTagCompound compound, ItemStack stack) {
        this.setSelectionRange(stack, compound.func_74760_g("selectionRange"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseInput(EntityPlayer player, ItemStack stack, int button, boolean buttonState, int dWheel) {
        if (this.modifierKeyDown() && dWheel != 0) {
            this.setSelectionRange(stack, MathHelper.func_76131_a((float)(this.getSelectionRange(stack) + (float)dWheel * 0.004f), (float)0.0f, (float)40.0f));
            RecurrentComplex.network.sendToServer((IMessage)new PacketSyncItem(player.field_71071_by.field_70461_c, stack));
            return true;
        }
        return false;
    }
}

