/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePath;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceMazePathConnectionList
extends TableDataSourceList<SavedMazePathConnection, List<SavedMazePathConnection>> {
    private int[] boundsLower;
    private int[] boundsHigher;

    public TableDataSourceMazePathConnectionList(List<SavedMazePathConnection> list, TableDelegate tableDelegate, TableNavigator navigator, int[] boundsLower, int[] boundsHigher) {
        super(list, tableDelegate, navigator);
        this.boundsLower = boundsLower;
        this.boundsHigher = boundsHigher;
        this.setEarlierTitle("Up");
        this.setLaterTitle("Down");
    }

    @Override
    public String getDisplayString(SavedMazePathConnection mazePath) {
        return String.format("%s %s%s%s", Arrays.toString(mazePath.path.sourceRoom.getCoordinates()), EnumChatFormatting.BLUE, TableDataSourceMazePath.directionFromPath(mazePath.path).toString(), EnumChatFormatting.RESET);
    }

    @Override
    public SavedMazePathConnection newEntry(String actionID) {
        return new SavedMazePathConnection(2, new MazeRoom(new int[this.boundsLower.length]), false, "Path");
    }

    @Override
    public TableDataSource editEntryDataSource(SavedMazePathConnection entry) {
        return new TableDataSourceMazePathConnection(entry, this.boundsLower, this.boundsHigher, this.tableDelegate);
    }
}

