/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.command;

import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellPresetAction;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.scripts.world.WorldScriptCommand;

public class TableDataSourceSpawnCommandEntry
extends TableDataSourceSegmented
implements TableCellPropertyListener,
TableCellActionListener {
    private WorldScriptCommand.Entry entry;
    private TableDelegate tableDelegate;

    public TableDataSourceSpawnCommandEntry(WorldScriptCommand.Entry entry, TableDelegate tableDelegate) {
        this.entry = entry;
        this.tableDelegate = tableDelegate;
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return 3;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (index == 0) {
            TableCellPresetAction cell = new TableCellPresetAction("default", "Apply", new TableCellButton.Action("spawner", "Mob Spawner"), new TableCellButton.Action("entity", "Spawn Entity"));
            cell.addListener(this);
            return new TableElementCell("Preset", cell);
        }
        if (index == 1) {
            TableCellString cell = new TableCellString("command", this.entry.command);
            cell.setMaxStringLength(Short.MAX_VALUE);
            cell.addPropertyListener(this);
            return new TableElementCell("Command", cell);
        }
        if (index == 2) {
            return RCGuiTables.defaultWeightElement(this, this.entry.weight);
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("command".equals(cell.getID())) {
            this.entry.command = (String)cell.getPropertyValue();
        } else if ("weight".equals(cell.getID())) {
            this.entry.weight = TableElements.toDouble((Float)cell.getPropertyValue());
        }
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if ("default".equals(cell.getID())) {
            if ("spawner".equals(actionID)) {
                this.entry.command = "/setblock ~ ~ ~ mob_spawner 0 replace {EntityId:Zombie}";
            } else if ("entity".equals(actionID)) {
                this.entry.command = "/summon Zombie ~ ~ ~";
            }
            this.tableDelegate.reloadData();
        }
    }
}

