/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSlider;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.utils.scale.Scale;
import ivorius.reccomplex.utils.scale.Scales;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.MathHelper;

public class TableCellFloatNullable
extends TableCellPropertyDefault<Float>
implements GuiControlListener<GuiSlider> {
    protected GuiSlider slider;
    protected GuiButton nullButton;
    protected boolean enabled = true;
    protected float defaultValue;
    protected float min;
    protected float max;
    protected Scale scale = Scales.none();
    protected String titleFormat = "%.4f";
    protected String buttonTitleNull;
    protected String buttonTitleCustom;
    protected float nullButtonWidth = 0.08f;

    public TableCellFloatNullable(String id, Float value, float defaultValue, float min, float max, String buttonTitleNull, String buttonTitleCustom) {
        super(id, value);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.buttonTitleNull = buttonTitleNull;
        this.buttonTitleCustom = buttonTitleCustom;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public String getTitleFormat() {
        return this.titleFormat;
    }

    public void setTitleFormat(String titleFormat) {
        this.titleFormat = titleFormat;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.slider != null) {
            this.slider.field_146124_l = enabled;
        }
    }

    public float getNullButtonWidth() {
        return this.nullButtonWidth;
    }

    public void setNullButtonWidth(float nullButtonWidth) {
        this.nullButtonWidth = nullButtonWidth;
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        int sliderWidth = MathHelper.func_76141_d((float)((float)bounds.getWidth() * (1.0f - this.nullButtonWidth))) - 2;
        this.slider = new GuiSlider(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, sliderWidth, 20, "");
        this.slider.setMinValue(this.scale.out(this.min));
        this.slider.setMaxValue(this.scale.out(this.max));
        this.slider.addListener((GuiControlListener)this);
        this.updateSliderValue();
        this.slider.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, (GuiButton)this.slider);
        int nullButtonWidth = MathHelper.func_76141_d((float)((float)bounds.getWidth() * this.nullButtonWidth)) - 2;
        this.nullButton = new GuiButton(-1, bounds.getMinX() + sliderWidth + 2, bounds.getMinY() + (bounds.getHeight() - 20) / 2, nullButtonWidth, 20, this.property != null ? this.buttonTitleCustom : this.buttonTitleNull);
        this.nullButton.field_146124_l = this.enabled;
        this.nullButton.field_146125_m = !this.isHidden();
        screen.addButton(this, 1, this.nullButton);
    }

    protected void updateSliderValue() {
        this.slider.field_146124_l = this.enabled && this.property != null;
        float activeValue = this.getActiveValue();
        this.slider.setValue(this.scale.out(activeValue));
        this.slider.field_146126_j = String.format(this.titleFormat, Float.valueOf(activeValue));
    }

    protected float getActiveValue() {
        return this.property != null ? ((Float)this.property).floatValue() : this.defaultValue;
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            boolean bl = this.slider.field_146125_m = !hidden;
        }
        if (this.nullButton != null) {
            this.nullButton.field_146125_m = !hidden;
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        if (buttonID == 1) {
            this.property = this.property != null ? null : Float.valueOf(this.defaultValue);
            this.nullButton.field_146126_j = this.property != null ? this.buttonTitleCustom : this.buttonTitleNull;
            this.updateSliderValue();
            this.alertListenersOfChange();
        }
    }

    public void valueChanged(GuiSlider gui) {
        this.property = Float.valueOf(this.scale.in(gui.getValue()));
        gui.field_146126_j = String.format(this.titleFormat, Float.valueOf(this.getActiveValue()));
        this.alertListenersOfChange();
    }

    @Override
    public void setPropertyValue(Float value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.updateSliderValue();
        }
    }
}

