/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSlider;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.utils.scale.Scale;
import ivorius.reccomplex.utils.scale.Scales;
import net.minecraft.client.gui.GuiButton;

public class TableCellFloat
extends TableCellPropertyDefault<Float>
implements GuiControlListener<GuiSlider> {
    protected GuiSlider slider;
    protected boolean enabled = true;
    protected float min;
    protected float max;
    protected Scale scale = Scales.none();
    protected String titleFormat = "%.4f";

    public TableCellFloat(String id, float value, float min, float max) {
        super(id, Float.valueOf(value));
        this.min = min;
        this.max = max;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public String getTitleFormat() {
        return this.titleFormat;
    }

    public void setTitleFormat(String titleFormat) {
        this.titleFormat = titleFormat;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.slider != null) {
            this.slider.field_146124_l = enabled;
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.slider = new GuiSlider(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, String.format(this.titleFormat, this.property));
        this.slider.setMinValue(this.scale.out(this.min));
        this.slider.setMaxValue(this.scale.out(this.max));
        this.slider.field_146124_l = this.enabled;
        this.slider.addListener((GuiControlListener)this);
        this.slider.setValue(this.scale.out(((Float)this.property).floatValue()));
        this.slider.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, (GuiButton)this.slider);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            this.slider.field_146125_m = !hidden;
        }
    }

    public void valueChanged(GuiSlider gui) {
        this.property = Float.valueOf(this.scale.in(gui.getValue()));
        gui.field_146126_j = String.format(this.titleFormat, this.property);
        this.alertListenersOfChange();
    }

    @Override
    public void setPropertyValue(Float value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.slider.setValue(this.scale.out(((Float)this.property).floatValue()));
            this.slider.field_146126_j = String.format(this.titleFormat, this.property);
        }
    }
}

