/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import com.google.common.collect.Lists;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.utils.IvTranslations;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.GuiButton;

public class TableCellEnum<T>
extends TableCellPropertyDefault<T> {
    private GuiButton button;
    private List<Option<T>> options;

    public TableCellEnum(String id, T value, List<Option<T>> options) {
        super(id, value);
        this.options = Lists.newArrayList(options);
    }

    @SafeVarargs
    public TableCellEnum(String id, T value, Option<T> ... options) {
        this(id, value, Arrays.asList(options));
    }

    public static <T extends Enum> List<Option<T>> options(List<T> values, String baseKey, boolean tooltip) {
        return TableCellEnum.options(values, (T input) -> IvTranslations.get(baseKey + IvGsonHelper.serializedName((Enum)input)), tooltip ? input -> IvTranslations.getLines(baseKey + IvGsonHelper.serializedName((Enum)input) + ".tooltip") : null);
    }

    public static <T extends Enum> List<Option<T>> options(List<T> values, Function<T, String> titleFunc, Function<T, List<String>> tooltipFunc) {
        return Lists.transform(values, input -> new Option<Enum>((Enum)input, titleFunc != null ? (String)titleFunc.apply(input) : null, tooltipFunc != null ? (List)tooltipFunc.apply(input) : null));
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.button = new GuiButton(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, "");
        this.button.field_146125_m = !this.isHidden();
        this.updateButtonTitle();
        screen.addButton(this, 0, this.button);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.button != null) {
            this.button.field_146125_m = !hidden;
        }
    }

    @Override
    public void setPropertyValue(T value) {
        super.setPropertyValue(value);
        this.updateButtonTitle();
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        int prevOptionIndex = this.currentOptionIndex();
        int optionIndex = prevOptionIndex < 0 ? 0 : (prevOptionIndex + 1) % this.options.size();
        this.setPropertyValue((T)this.options.get((int)optionIndex).value);
        this.alertListenersOfChange();
    }

    @Override
    public void drawFloating(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.drawFloating(screen, mouseX, mouseY, partialTicks);
        Option<T> option = this.currentOption();
        if (option != null && option.tooltip != null) {
            screen.drawTooltipRect(option.tooltip, this.bounds(), mouseX, mouseY, this.getFontRenderer());
        }
    }

    private void updateButtonTitle() {
        if (this.button != null) {
            int index = this.currentOptionIndex();
            this.button.field_146126_j = index >= 0 ? this.options.get((int)index).title : (this.getPropertyValue() != null ? this.getPropertyValue().toString() : "null");
        }
    }

    private Option<T> currentOption() {
        int index = this.currentOptionIndex();
        return index >= 0 ? this.options.get(index) : null;
    }

    private int currentOptionIndex() {
        for (int i = 0; i < this.options.size(); ++i) {
            if (!Objects.equals(this.options.get((int)i).value, this.getPropertyValue())) continue;
            return i;
        }
        return -1;
    }

    public static class Option<T> {
        public T value;
        public String title;
        public List<String> tooltip;

        public Option(T value, String title) {
            this.value = value;
            this.title = title;
        }

        public Option(T value, String title, List<String> tooltip) {
            this.value = value;
            this.title = title;
            this.tooltip = tooltip;
        }
    }
}

