/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import com.google.common.primitives.Ints;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.editstructure.TableDataSourceYSelector;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationInfo;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.gentypes.StaticGenerationInfo;

public class TableDataSourceStaticGenerationInfo
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private StaticGenerationInfo generationInfo;

    public TableDataSourceStaticGenerationInfo(TableNavigator navigator, TableDelegate tableDelegate, StaticGenerationInfo generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSection(0, new TableDataSourceGenerationInfo(generationInfo));
        this.addManagedSection(2, new TableDataSourceYSelector(generationInfo.ySelector));
        this.addManagedSection(3, TableDataSourceExpression.constructDefault("Dimensions", generationInfo.dimensionMatcher));
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 3;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                if (index == 0) {
                    TableCellBoolean cell = new TableCellBoolean("relativeToSpawn", this.generationInfo.relativeToSpawn);
                    cell.addPropertyListener(this);
                    return new TableElementCell("At Spawn", cell);
                }
                if (index == 1) {
                    TableCellString cell = new TableCellString("positionX", String.valueOf(this.generationInfo.positionX));
                    cell.setShowsValidityState(true);
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                    cell.addPropertyListener(this);
                    return new TableElementCell("Position (x)", cell);
                }
                if (index != 2) break;
                TableCellString cell = new TableCellString("positionZ", String.valueOf(this.generationInfo.positionZ));
                cell.setShowsValidityState(true);
                cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                cell.addPropertyListener(this);
                return new TableElementCell("Position (z)", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "positionX": {
                    Integer val = Ints.tryParse((String)((String)cell.getPropertyValue()));
                    this.generationInfo.positionX = val != null ? val : 0;
                    ((TableCellString)cell).setValidityState(val != null ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID);
                    break;
                }
                case "positionZ": {
                    Integer val = Ints.tryParse((String)((String)cell.getPropertyValue()));
                    this.generationInfo.positionZ = val != null ? val : 0;
                    ((TableCellString)cell).setValidityState(val != null ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID);
                    break;
                }
                case "relativeToSpawn": {
                    this.generationInfo.relativeToSpawn = (Boolean)cell.getPropertyValue();
                }
            }
        }
    }
}

