/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.utils.IvTranslations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.StatCollector;

public class TableDataSourceStructureGenerationInfoList
extends TableDataSourceList<StructureGenerationInfo, List<StructureGenerationInfo>> {
    public TableDataSourceStructureGenerationInfoList(List<StructureGenerationInfo> list, TableDelegate tableDelegate, TableNavigator navigator) {
        super(list, tableDelegate, navigator);
        this.setUsesPresetActionForAdding(true);
        this.setEarlierTitle("Up");
        this.setLaterTitle("Down");
    }

    @Override
    public TableCellButton.Action[] getAddActions() {
        Collection<String> allTypes = StructureRegistry.INSTANCE.getStructureGenerationInfoRegistry().allIDs();
        ArrayList<TableCellButton.Action> actions = new ArrayList<TableCellButton.Action>(allTypes.size());
        for (String type : allTypes) {
            String baseKey = "reccomplex.generationInfo." + type;
            actions.add(new TableCellButton.Action(type, StatCollector.func_74838_a((String)baseKey), IvTranslations.formatLines(baseKey + ".tooltip", new Object[0])));
        }
        return actions.toArray(new TableCellButton.Action[actions.size()]);
    }

    @Override
    public String getDisplayString(StructureGenerationInfo structureGenerationInfo) {
        return structureGenerationInfo.displayString();
    }

    @Override
    public StructureGenerationInfo newEntry(String actionID) {
        Class<StructureGenerationInfo> clazz = StructureRegistry.INSTANCE.getStructureGenerationInfoRegistry().typeForID(actionID);
        return this.instantiateStructureGenerationInfo(clazz);
    }

    @Override
    public TableDataSource editEntryDataSource(StructureGenerationInfo entry) {
        return entry.tableDataSource(this.navigator, this.tableDelegate);
    }

    public StructureGenerationInfo instantiateStructureGenerationInfo(Class<? extends StructureGenerationInfo> clazz) {
        StructureGenerationInfo generationInfo = null;
        try {
            generationInfo = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            RecurrentComplex.logger.error((Object)e);
        }
        return generationInfo;
    }
}

