/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.files.RCFileTypeRegistry;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.editstructure.TableDataSourceMetadata;
import ivorius.reccomplex.gui.editstructure.TableDataSourceStructureGenerationInfoList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceTransformerList;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellMulti;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.utils.IvTranslations;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceGenericStructure
extends TableDataSourceSegmented
implements TableCellActionListener,
TableCellPropertyListener {
    private GenericStructureInfo structureInfo;
    private String structureKey;
    private boolean saveAsActive;
    private boolean deleteOther = true;
    private boolean structureInActive;
    private boolean structureInInactive;
    private TableDelegate tableDelegate;
    private TableNavigator navigator;

    public TableDataSourceGenericStructure(GenericStructureInfo structureInfo, String structureKey, boolean saveAsActive, boolean structureInActive, boolean structureInInactive, TableDelegate tableDelegate, TableNavigator navigator) {
        this.structureInfo = structureInfo;
        this.structureKey = structureKey;
        this.saveAsActive = saveAsActive;
        this.structureInActive = structureInActive;
        this.structureInInactive = structureInInactive;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
        this.addManagedSection(3, TableDataSourceExpression.constructDefault("Dependencies", structureInfo.dependencies));
    }

    public GenericStructureInfo getStructureInfo() {
        return this.structureInfo;
    }

    public void setStructureInfo(GenericStructureInfo structureInfo) {
        this.structureInfo = structureInfo;
    }

    public String getStructureKey() {
        return this.structureKey;
    }

    public void setStructureKey(String structureKey) {
        this.structureKey = structureKey;
    }

    public boolean isSaveAsActive() {
        return this.saveAsActive;
    }

    public void setSaveAsActive(boolean saveAsActive) {
        this.saveAsActive = saveAsActive;
    }

    public boolean isDeleteOther() {
        return this.deleteOther;
    }

    public void setDeleteOther(boolean deleteOther) {
        this.deleteOther = deleteOther;
    }

    public boolean isStructureInActive() {
        return this.structureInActive;
    }

    public void setStructureInActive(boolean structureInActive) {
        this.structureInActive = structureInActive;
    }

    public boolean isStructureInInactive() {
        return this.structureInInactive;
    }

    public void setStructureInInactive(boolean structureInInactive) {
        this.structureInInactive = structureInInactive;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    public int numberOfSegments() {
        return 6;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 0: {
                if (index == 0) {
                    TableCellString cell = new TableCellString("name", this.structureKey);
                    cell.setTooltip(IvTranslations.formatLines("reccomplex.structure.id.tooltip", new Object[0]));
                    cell.addPropertyListener(this);
                    cell.setShowsValidityState(true);
                    cell.setValidityState(this.currentNameState());
                    return new TableElementCell(IvTranslations.get("reccomplex.structure.id"), cell);
                }
                if (index != 1) break;
                TableCellBoolean cellFolder = new TableCellBoolean("activeFolder", this.saveAsActive, IvTranslations.format("reccomplex.structure.savePath", String.format("%s/%s%s", EnumChatFormatting.AQUA, RCFileTypeRegistry.getStructuresDirectoryName(true), EnumChatFormatting.RESET)), IvTranslations.format("reccomplex.structure.savePath", String.format("%s/%s%s", EnumChatFormatting.AQUA, RCFileTypeRegistry.getStructuresDirectoryName(false), EnumChatFormatting.RESET)));
                cellFolder.addPropertyListener(this);
                if (this.saveAsActive ? this.structureInInactive : this.structureInActive) {
                    String path = RCFileTypeRegistry.getStructuresDirectoryName(!this.saveAsActive);
                    TableCellBoolean cellDelete = new TableCellBoolean("deleteOther", this.deleteOther, IvTranslations.format("reccomplex.structure.deleteOther.true", EnumChatFormatting.RED, EnumChatFormatting.RESET, String.format("%s/%s%s", EnumChatFormatting.AQUA, path, EnumChatFormatting.RESET)), IvTranslations.format("reccomplex.structure.deleteOther.false", EnumChatFormatting.YELLOW, EnumChatFormatting.RESET, String.format("%s/%s%s", EnumChatFormatting.AQUA, path, EnumChatFormatting.RESET)));
                    cellDelete.addPropertyListener(this);
                    cellDelete.setTooltip(IvTranslations.formatLines("reccomplex.structure.deleteOther.tooltip", EnumChatFormatting.AQUA + RCFileTypeRegistry.getStructuresDirectoryName(false) + EnumChatFormatting.RESET, EnumChatFormatting.AQUA + RCFileTypeRegistry.getStructuresDirectoryName(true) + EnumChatFormatting.RESET));
                    return new TableElementCell(new TableCellMulti(cellFolder, cellDelete));
                }
                return new TableElementCell(new TableCellMulti(cellFolder, new TableCellButton("", new TableCellButton.Action("", "-", false))));
            }
            case 1: {
                TableCellButton cell = new TableCellButton("metadata", new TableCellButton.Action("metadata", "Metadata"));
                cell.addListener(this);
                return new TableElementCell(cell);
            }
            case 2: {
                TableCellBoolean cellRotatable = new TableCellBoolean("rotatable", this.structureInfo.rotatable, IvTranslations.get("reccomplex.structure.rotatable.true"), IvTranslations.get("reccomplex.structure.rotatable.false"));
                cellRotatable.setTooltip(IvTranslations.formatLines("reccomplex.structure.rotatable.tooltip", new Object[0]));
                cellRotatable.addPropertyListener(this);
                TableCellBoolean cellMirrorable = new TableCellBoolean("mirrorable", this.structureInfo.mirrorable, IvTranslations.format("reccomplex.structure.mirrorable.true", new Object[0]), IvTranslations.format("reccomplex.structure.mirrorable.false", new Object[0]));
                cellMirrorable.setTooltip(IvTranslations.formatLines("reccomplex.structure.mirrorable.tooltip", new Object[0]));
                cellMirrorable.addPropertyListener(this);
                return new TableElementCell(new TableCellMulti(cellRotatable, cellMirrorable));
            }
            case 4: {
                TableCellButton cell = new TableCellButton("editGenerationInfos", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Generation", cell);
            }
            case 5: {
                TableCellButton cell = new TableCellButton("editTransformers", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Transformers", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if ("metadata".equals(actionID)) {
            GuiTable table = new GuiTable(this.tableDelegate, new TableDataSourceMetadata(this.structureInfo.metadata));
            this.navigator.pushTable(table);
        } else if ("editTransformers".equals(cell.getID()) && "edit".equals(actionID)) {
            GuiTable editTransformersProperties = new GuiTable(this.tableDelegate, new TableDataSourceTransformerList(this.structureInfo.transformers, this.tableDelegate, this.navigator));
            this.navigator.pushTable(editTransformersProperties);
        } else if ("editGenerationInfos".equals(cell.getID()) && "edit".equals(actionID)) {
            GuiTable editGenerationProperties = new GuiTable(this.tableDelegate, new TableDataSourceStructureGenerationInfoList(this.structureInfo.generationInfos, this.tableDelegate, this.navigator));
            this.navigator.pushTable(editGenerationProperties);
        }
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "name": {
                    this.structureKey = (String)cell.getPropertyValue();
                    ((TableCellString)cell).setValidityState(this.currentNameState());
                    break;
                }
                case "activeFolder": {
                    this.saveAsActive = (Boolean)cell.getPropertyValue();
                    this.tableDelegate.reloadData();
                    break;
                }
                case "deleteOther": {
                    this.deleteOther = (Boolean)cell.getPropertyValue();
                    break;
                }
                case "rotatable": {
                    this.structureInfo.rotatable = (Boolean)cell.getPropertyValue();
                    break;
                }
                case "mirrorable": {
                    this.structureInfo.mirrorable = (Boolean)cell.getPropertyValue();
                }
            }
        }
    }

    private GuiValidityStateIndicator.State currentNameState() {
        if (StructureRegistry.INSTANCE.allStructureIDs().contains(this.structureKey)) {
            return GuiValidityStateIndicator.State.SEMI_VALID;
        }
        return this.structureKey.trim().length() > 0 && !this.structureKey.contains(" ") ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID;
    }
}

