/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.commands.CommandSelectModify;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CommandSelectFloor
extends CommandSelectModify {
    public static void placeNaturalFloor(World world, BlockArea area, double lowerExpansion) {
        lowerExpansion += 0.01;
        Block floorBlock = RCBlocks.genericSolid;
        Block airBlock1 = RCBlocks.genericSpace;
        BlockCoord lowerPoint = area.getLowerCorner();
        BlockCoord higherPoint = area.getHigherCorner();
        HashSet<BlockCoord> stopped = new HashSet<BlockCoord>();
        HashSet<BlockCoord> stopping = new HashSet<BlockCoord>();
        for (int y = lowerPoint.y + 1; y <= higherPoint.y; ++y) {
            for (BlockCoord surfaceCoord : BlockAreas.side((BlockArea)area, (ForgeDirection)ForgeDirection.DOWN)) {
                Block block;
                if (stopped.contains(surfaceCoord) || (block = world.func_147439_a(surfaceCoord.x, y, surfaceCoord.z)).func_149688_o() == Material.field_151579_a || block == airBlock1 || !block.isNormalCube((IBlockAccess)world, surfaceCoord.x, y, surfaceCoord.z) || block == floorBlock || y <= lowerPoint.y) continue;
                CommandSelectFloor.setBlockIfAirInArea(world, new BlockCoord(surfaceCoord.x, y - 1, surfaceCoord.z), floorBlock, area);
                CommandSelectFloor.fillSurface(world, area, lowerExpansion, floorBlock, surfaceCoord, y, stopping);
            }
            stopped.addAll(stopping);
            stopping.clear();
        }
    }

    private static void fillSurface(World world, BlockArea area, double expansion, Block floorBlock, BlockCoord surfaceCoord, int y, Set<BlockCoord> coords) {
        int expX = MathHelper.func_76143_f((double)(-expansion));
        while ((double)expX <= expansion) {
            int expZ = MathHelper.func_76143_f((double)(-expansion));
            while ((double)expZ <= expansion) {
                if ((double)(expX * expX + expZ * expZ) <= expansion * expansion) {
                    BlockCoord coord = new BlockCoord(surfaceCoord.x + expX, y - 1, surfaceCoord.z + expZ);
                    CommandSelectFloor.setBlockIfAirInArea(world, coord, floorBlock, area);
                    coords.add(coord);
                }
                ++expZ;
            }
            ++expX;
        }
    }

    public static void setBlockIfAirInArea(World world, BlockCoord coord, Block block, BlockArea area) {
        Block prevBlock;
        if (area.contains(coord) && ((prevBlock = world.func_147439_a(coord.x, coord.y, coord.z)).func_149688_o() == Material.field_151579_a || prevBlock == RCBlocks.genericSpace)) {
            world.func_147449_b(coord.x, coord.y, coord.z, block);
        }
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "floor";
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.selectFloor.usage");
    }

    @Override
    public void processCommandSelection(EntityPlayerMP player, StructureEntityInfo structureEntityInfo, BlockCoord point1, BlockCoord point2, String[] args) {
        World world = player.func_130014_f_();
        BlockArea area = new BlockArea(point1, point2);
        double expandFloor = args.length >= 1 ? CommandSelectFloor.func_82363_b((ICommandSender)player, (String)args[0]) : 1.0;
        CommandSelectFloor.placeNaturalFloor(world, area, expandFloor);
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandSelectFloor.func_71530_a((String[])args, (String[])new String[]{"0", "1", "2"});
        }
        return super.func_71516_a(commandSender, args);
    }
}

