/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.client.rendering;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.AreaRenderer;
import ivorius.ivtoolkit.rendering.grid.CubeMesh;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.client.rendering.SelectionRenderer;
import ivorius.reccomplex.utils.Icons;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class OperationRenderer {
    public static void applyTransformVisual(AxisAlignedTransform2D transform2D, float[] size) {
        if (transform2D.getRotation() % 2 == 1) {
            GL11.glTranslatef((float)(size[2] * 0.5f), (float)0.0f, (float)(size[0] * 0.5f));
        } else {
            GL11.glTranslatef((float)(size[0] * 0.5f), (float)0.0f, (float)(size[2] * 0.5f));
        }
        GL11.glRotatef((float)(-90.0f * (float)transform2D.getRotation()), (float)0.0f, (float)1.0f, (float)0.0f);
        if (transform2D.isMirrorX()) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)(-size[0] * 0.5f), (float)0.0f, (float)(-size[2] * 0.5f));
    }

    public static void renderGridQuadCache(GridQuadCache<?> cached, AxisAlignedTransform2D transform, BlockCoord lowerCoord, int ticks, float partialTicks) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        GL11.glDisable((int)2884);
        ResourceLocation curTex = Icons.frame(SelectionRenderer.LATTICE_TEXTURE, ((float)ticks + partialTicks) * 0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(curTex);
        GL11.glPushMatrix();
        GL11.glTranslated((double)lowerCoord.x, (double)lowerCoord.y, (double)lowerCoord.z);
        OperationRenderer.applyTransformVisual(transform, cached.getSize());
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (GridQuadCache.CachedQuadLevel cachedQuadLevel : cached) {
            ForgeDirection direction = cachedQuadLevel.direction;
            float zLevel = cachedQuadLevel.zLevel + 0.01f * (float)(direction.offsetX + direction.offsetY + direction.offsetZ);
            FloatBuffer quads = cachedQuadLevel.quads;
            while (quads.position() < quads.limit() - 3) {
                float minX = quads.get();
                float minY = quads.get();
                float maxX = quads.get();
                float maxY = quads.get();
                float[] minAxes = GridQuadCache.getNormalAxes((ForgeDirection)direction, (float[])new float[]{zLevel, minX, minY});
                float[] maxAxes = GridQuadCache.getNormalAxes((ForgeDirection)direction, (float[])new float[]{zLevel, maxX, maxY});
                CubeMesh.renderSide((ForgeDirection)direction, (double)minAxes[0], (double)minAxes[1], (double)minAxes[2], (double)maxAxes[0], (double)maxAxes[1], (double)maxAxes[2], (IIcon)Icons.from(minX, minY, maxX, maxY));
            }
            quads.position(0);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
        GL11.glAlphaFunc((int)516, (float)0.002f);
        GL11.glDisable((int)3042);
    }

    public static void maybeRenderBoundingBox(BlockCoord lowerCoord, int[] size, int ticks, float partialTicks) {
        if (size[0] > 0 && size[1] > 0 && size[2] > 0) {
            OperationRenderer.renderBoundingBox(BlockArea.areaFromSize((BlockCoord)lowerCoord, (int[])size), ticks, partialTicks);
        }
    }

    public static void renderBoundingBox(BlockArea area, int ticks, float partialTicks) {
        GL11.glLineWidth((float)3.0f);
        GL11.glColor3f((float)0.8f, (float)0.8f, (float)1.0f);
        AreaRenderer.renderAreaLined((BlockArea)area, (float)0.0232f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)1.0E-4f);
        ResourceLocation curTex = Icons.frame(SelectionRenderer.TEXTURE, ((float)ticks + partialTicks) * 0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(curTex);
        GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.8f, (float)0.3f);
        AreaRenderer.renderArea((BlockArea)area, (boolean)false, (boolean)true, (float)0.0132f);
        GL11.glColor4f((float)0.8f, (float)0.8f, (float)1.0f, (float)0.5f);
        AreaRenderer.renderArea((BlockArea)area, (boolean)false, (boolean)false, (float)0.0132f);
        GL11.glAlphaFunc((int)516, (float)0.002f);
        GL11.glDisable((int)3042);
    }
}

