/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.helpers.SoundDeviceThread;
import org.embeddedt.archaicfix.occlusion.OcclusionHelpers;
import org.embeddedt.archaicfix.proxy.CommonProxy;
import zone.rong.loliasm.api.LoliStringPool;

public class ClientProxy
extends CommonProxy {
    SoundDeviceThread soundThread = null;
    public static volatile boolean soundSystemReloadLock = false;
    float lastIntegratedTickTime;

    @Override
    public void preinit() {
        super.preinit();
        Minecraft.field_71444_a = new byte[0];
        if (ArchaicConfig.enableOcclusionTweaks) {
            OcclusionHelpers.init();
        }
        MinecraftForge.EVENT_BUS.register((Object)new LoliStringPool.EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.phase == TickEvent.Phase.END) {
            IntegratedServer srv = Minecraft.func_71410_x().func_71401_C();
            if (srv != null) {
                long currentTickTime = srv.field_71311_j[srv.func_71259_af() % 100];
                this.lastIntegratedTickTime = this.lastIntegratedTickTime * 0.8f + (float)currentTickTime / 1000000.0f * 0.2f;
            } else {
                this.lastIntegratedTickTime = 0.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        IntegratedServer srv;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!minecraft.field_71474_y.field_74330_P || event.left.size() < 1) {
            return;
        }
        NetHandlerPlayClient cl = minecraft.func_147114_u();
        if (cl != null && (srv = minecraft.func_71401_C()) != null) {
            String s = String.format("Integrated server @ %.0f ms ticks", Float.valueOf(this.lastIntegratedTickTime));
            event.left.add(1, s);
        }
        if (ArchaicConfig.showBlockDebugInfo && minecraft.field_71476_x != null && minecraft.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (((String)event.right.get(event.right.size() - 1)).length() > 0) {
                event.right.add("");
            }
            Block block = minecraft.field_71441_e.func_147439_a(minecraft.field_71476_x.field_72311_b, minecraft.field_71476_x.field_72312_c, minecraft.field_71476_x.field_72309_d);
            int meta = minecraft.field_71441_e.func_72805_g(minecraft.field_71476_x.field_72311_b, minecraft.field_71476_x.field_72312_c, minecraft.field_71476_x.field_72309_d);
            event.right.add(Block.field_149771_c.func_148750_c((Object)block));
            event.right.add("meta: " + meta);
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        soundSystemReloadLock = false;
        if (this.soundThread == null) {
            ArchaicLogger.LOGGER.info("Starting sound device thread");
            this.soundThread = new SoundDeviceThread();
            this.soundThread.start();
        }
    }
}

