/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.occlusion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.chunk.Chunk;
import org.embeddedt.archaicfix.occlusion.ICulledChunk;
import org.embeddedt.archaicfix.occlusion.IRenderGlobal;
import org.embeddedt.archaicfix.occlusion.IWorldRenderer;
import org.embeddedt.archaicfix.occlusion.SetVisibility;
import org.embeddedt.archaicfix.occlusion.VisGraph;
import org.embeddedt.archaicfix.occlusion.util.IntStack;

public class OcclusionHelpers {
    public static RenderWorker worker;
    public static long chunkUpdateDeadline;
    public static float partialTickTime;
    public static final boolean DEBUG_ALWAYS_RUN_OCCLUSION;
    public static final boolean DEBUG_PRINT_QUEUE_ITERATIONS;
    public static final boolean DEBUG_LAZY_CHUNK_UPDATES;
    public static final boolean DEBUG_NO_UPDATE_ACCELERATION;
    public static IntStack deferredAreas;

    public static void init() {
        worker = new RenderWorker();
    }

    public static synchronized void updateArea(int x, int y, int z, int x2, int y2, int z2) {
        deferredAreas.add(z2);
        deferredAreas.add(y2);
        deferredAreas.add(x2);
        deferredAreas.add(z);
        deferredAreas.add(y);
        deferredAreas.add(x);
    }

    public static synchronized void processUpdate(IRenderGlobal render) {
        if (deferredAreas.isEmpty()) {
            return;
        }
        int x = deferredAreas.pop();
        int y = deferredAreas.pop();
        int z = deferredAreas.pop();
        int x2 = deferredAreas.pop();
        int y2 = deferredAreas.pop();
        int z2 = deferredAreas.pop();
        render.internalMarkBlockUpdate(x, y, z, x2, y2, z2);
    }

    public static void updateRendererNeighbors(RenderGlobal rg, WorldRenderer[] worldRenderers, int renderChunksWide, int renderChunksDeep, int renderChunksTall) {
        if (worldRenderers == null) {
            return;
        }
        for (int i = 0; i < worldRenderers.length; ++i) {
            VisGraph oSides;
            WorldRenderer rend = worldRenderers[i];
            RenderWorker.CullInfo ci = ((IWorldRenderer)rend).arch$getCullInfo();
            ci.wrIdx = i;
            Chunk o = rend.field_78924_a.func_72938_d(rend.field_78923_c, rend.field_78921_e);
            ci.visGraph = oSides = OcclusionHelpers.isChunkEmpty(o) ? RenderWorker.DUMMY : ((ICulledChunk)o).getVisibility()[rend.field_78920_d >> 4];
            ci.vis = oSides.getVisibilityArray();
            EnumFacing[] enumFacingArray = EnumFacing.values();
            int n = enumFacingArray.length;
            for (int j = 0; j < n; ++j) {
                EnumFacing dir;
                WorldRenderer neighbor = ((IRenderGlobal)rg).getRenderer(rend.field_78923_c + (dir = enumFacingArray[j]).func_82601_c() * 16, rend.field_78920_d + dir.func_96559_d() * 16, rend.field_78921_e + dir.func_82599_e() * 16);
                ci.setNeighbor(dir, neighbor == null ? null : ((IWorldRenderer)neighbor).arch$getCullInfo());
            }
        }
    }

    private static boolean isChunkEmpty(Chunk chunk) {
        return chunk == null || chunk.func_76621_g();
    }

    static {
        DEBUG_ALWAYS_RUN_OCCLUSION = Boolean.parseBoolean(System.getProperty("archaicfix.debug.alwaysRunOcclusion", "false"));
        DEBUG_PRINT_QUEUE_ITERATIONS = Boolean.parseBoolean(System.getProperty("archaicfix.debug.printQueueIterations", "false"));
        DEBUG_LAZY_CHUNK_UPDATES = Boolean.parseBoolean(System.getProperty("archaicfix.debug.lazyChunkUpdates", "false"));
        DEBUG_NO_UPDATE_ACCELERATION = Boolean.parseBoolean(System.getProperty("archaicfix.debug.noUpdateAcceleration", "false"));
        deferredAreas = new IntStack(6144);
    }

    public static enum RenderPosition {
        DOWN(EnumFacing.DOWN, 0, -1, 0),
        UP(EnumFacing.UP, 0, 16, 0),
        WEST(EnumFacing.EAST, -1, 0, 0),
        EAST(EnumFacing.WEST, 16, 0, 0),
        NORTH(EnumFacing.NORTH, 0, 0, -1),
        SOUTH(EnumFacing.SOUTH, 0, 0, 16),
        NONE(null, 0, 0, 0),
        NONE_opp(null, 0, 0, 0);

        public static final RenderPosition[] POSITIONS;
        public static final RenderPosition[][] POSITIONS_BIAS;
        public static final RenderPosition[] FROM_FACING;
        public static final List<RenderPosition> SIDES;
        public final int x;
        public final int y;
        public final int z;
        public final EnumFacing facing;
        private final int _x;
        private final int _y;
        private final int _z;

        private RenderPosition(EnumFacing face, int x, int y, int z) {
            this.facing = face;
            this.x = x;
            this.y = y;
            this.z = z;
            this._x = x > 0 ? 1 : x;
            this._y = y > 0 ? 1 : y;
            this._z = z > 0 ? 1 : z;
        }

        public RenderPosition getOpposite() {
            return POSITIONS[this.ordinal() ^ 1];
        }

        static {
            POSITIONS = RenderPosition.values();
            POSITIONS_BIAS = new RenderPosition[6][6];
            FROM_FACING = new RenderPosition[6];
            SIDES = Arrays.asList(POSITIONS).subList(1, 6);
            block5: for (int i = 0; i < 6; ++i) {
                RenderPosition pos;
                RenderPosition.FROM_FACING[pos.facing.ordinal()] = pos = POSITIONS[i];
                RenderPosition[] bias = POSITIONS_BIAS[i];
                int j = 0;
                int xor = pos.ordinal() & 1;
                switch (pos) {
                    case DOWN: 
                    case UP: {
                        bias[j++] = pos;
                        bias[j++] = POSITIONS[NORTH.ordinal() ^ xor];
                        bias[j++] = POSITIONS[SOUTH.ordinal() ^ xor];
                        bias[j++] = POSITIONS[EAST.ordinal() ^ xor];
                        bias[j++] = POSITIONS[WEST.ordinal() ^ xor];
                        bias[j++] = pos.getOpposite();
                        continue block5;
                    }
                    case WEST: 
                    case EAST: {
                        bias[j++] = pos;
                        bias[j++] = POSITIONS[NORTH.ordinal() ^ xor];
                        bias[j++] = POSITIONS[SOUTH.ordinal() ^ xor];
                        bias[j++] = POSITIONS[UP.ordinal() ^ xor];
                        bias[j++] = POSITIONS[DOWN.ordinal() ^ xor];
                        bias[j++] = pos.getOpposite();
                        continue block5;
                    }
                    case NORTH: 
                    case SOUTH: {
                        bias[j++] = pos;
                        bias[j++] = POSITIONS[EAST.ordinal() ^ xor];
                        bias[j++] = POSITIONS[WEST.ordinal() ^ xor];
                        bias[j++] = POSITIONS[UP.ordinal() ^ xor];
                        bias[j++] = POSITIONS[DOWN.ordinal() ^ xor];
                        bias[j++] = pos.getOpposite();
                        continue block5;
                    }
                }
            }
        }
    }

    public static class RenderWorker {
        private static final VisGraph DUMMY = new VisGraph();
        public volatile boolean dirty = false;
        public int dirtyFrustumRenderers;
        private int frame = 0;
        private final List<CullInfo> queue = new ArrayList<CullInfo>();
        private Frustrum fStack = new Frustrum();
        private WorldClient theWorld;
        private RenderGlobal render;
        private boolean[] isWRInFrustum;
        private final Minecraft mc = Minecraft.func_71410_x();

        public void setWorld(RenderGlobal rg, WorldClient world) {
            this.render = rg;
            this.theWorld = world;
        }

        public void run(boolean immediate) {
            ++this.frame;
            this.queue.clear();
            int queueIterations = 0;
            if (this.render == null) {
                return;
            }
            EntityLivingBase view = this.mc.field_71451_h;
            if (this.theWorld == null || view == null) {
                return;
            }
            long t0 = DEBUG_PRINT_QUEUE_ITERATIONS ? System.nanoTime() : 0L;
            Frustrum frustum = this.getFrustum();
            this.theWorld.field_72984_F.func_76320_a("prep");
            this.prepareRenderers();
            this.seedQueue(frustum);
            long t1 = DEBUG_PRINT_QUEUE_ITERATIONS ? System.nanoTime() : 0L;
            this.theWorld.field_72984_F.func_76318_c("process_queue");
            for (int i = 0; i < this.queue.size(); ++i) {
                ++queueIterations;
                CullInfo ci = this.queue.get(i);
                for (RenderPosition stepPos : CullInfo.ALLOWED_STEPS[ci.facings & 0x3F]) {
                    if (!this.canStep(ci, stepPos)) continue;
                    this.maybeEnqueueNeighbor(ci, stepPos, this.queue, frustum);
                }
            }
            this.theWorld.field_72984_F.func_76318_c("cleanup");
            long t2 = DEBUG_PRINT_QUEUE_ITERATIONS ? System.nanoTime() : 0L;
            for (CullInfo ci : this.queue) {
                this.markRenderer(ci, view);
            }
            if (DEBUG_PRINT_QUEUE_ITERATIONS) {
                if (queueIterations != 0) {
                    System.out.println("queue iterations: " + queueIterations);
                }
                long t3 = System.nanoTime();
                System.out.println((double)(t1 - t0) / 1000000.0 + " ms prepare + " + (double)(t2 - t1) / 1000000.0 + " ms queue + " + (double)(t3 - t2) / 1000000.0 + " ms mark");
            }
            this.dirty = false;
            this.queue.clear();
            this.theWorld.field_72984_F.func_76319_b();
        }

        private void prepareRenderers() {
            if (this.isWRInFrustum == null || this.isWRInFrustum.length != this.render.field_72765_l.length) {
                this.isWRInFrustum = new boolean[this.render.field_72765_l.length];
            }
            for (int i = 0; i < this.render.field_72765_l.length; ++i) {
                WorldRenderer wr = this.render.field_72765_l[i];
                wr.field_78936_t = false;
                this.isWRInFrustum[i] = wr.field_78927_l;
            }
            this.render.field_72751_K = 0;
        }

        private Frustrum getFrustum() {
            EntityLivingBase view = this.mc.field_71451_h;
            Frustrum frustum = new Frustrum();
            frustum.func_78547_a(view.field_70165_t, view.field_70163_u, view.field_70161_v);
            return frustum;
        }

        private void seedQueue(Frustrum frustum) {
            EntityLivingBase view = this.mc.field_71451_h;
            int viewX = MathHelper.func_76128_c((double)view.field_70165_t);
            int viewY = MathHelper.func_76128_c((double)(view.field_70163_u + (double)view.func_70047_e()));
            int viewZ = MathHelper.func_76128_c((double)view.field_70161_v);
            this.theWorld.field_72984_F.func_76318_c("gather_chunks");
            IRenderGlobal extendedRender = (IRenderGlobal)this.render;
            this.theWorld.field_72984_F.func_76318_c("seed_queue");
            WorldRenderer center = extendedRender.getRenderer(viewX, viewY, viewZ);
            if (center != null) {
                CullInfo ci = ((IWorldRenderer)center).arch$getCullInfo();
                this.isInFrustum(ci, frustum);
                ci.init(RenderPosition.NONE, (byte)0);
                this.queue.add(ci);
            } else {
                int level = viewY > 5 ? 250 : 5;
                center = extendedRender.getRenderer(viewX, level, viewZ);
                if (center != null) {
                    RenderPosition pos = viewY < 5 ? RenderPosition.UP : RenderPosition.DOWN;
                    CullInfo ci = ((IWorldRenderer)center).arch$getCullInfo();
                    ci.init(RenderPosition.NONE, (byte)0);
                    this.queue.add(ci);
                    boolean allNull = false;
                    this.theWorld.field_72984_F.func_76320_a("gather_world");
                    int size = 1;
                    while (!allNull) {
                        allNull = true;
                        int i = 0;
                        int j = size;
                        while (i < size) {
                            for (int k = 0; k < 4; ++k) {
                                CullInfo ci2;
                                int zm;
                                int xm = (k & 1) == 0 ? -1 : 1;
                                center = extendedRender.getRenderer(viewX + i * 16 * xm, level, viewZ + j * 16 * (zm = (k & 2) == 0 ? -1 : 1));
                                if (center == null || !this.isInFrustum(ci2 = ((IWorldRenderer)center).arch$getCullInfo(), frustum)) continue;
                                allNull = false;
                                ci2.init(RenderPosition.NONE, (byte)0);
                                this.queue.add(ci2);
                            }
                            ++i;
                            --j;
                        }
                        ++size;
                    }
                    this.theWorld.field_72984_F.func_76319_b();
                }
            }
        }

        private boolean canStep(CullInfo info, RenderPosition stepPos) {
            boolean allVis;
            boolean bl = allVis = this.mc.field_71442_b.field_78779_k.func_77148_a() == 3;
            return allVis || SetVisibility.isVisible(info.vis[0], info.dir.getOpposite().facing, stepPos.facing);
        }

        private void maybeEnqueueNeighbor(CullInfo info, RenderPosition stepPos, Collection<CullInfo> queue, Frustrum frustum) {
            CullInfo neighbor = info.getNeighbor(stepPos.facing);
            if (neighbor == null || !neighbor.setLastCullUpdateFrame(this.frame) || !this.isInFrustum(neighbor, frustum)) {
                return;
            }
            neighbor.init(stepPos, info.facings);
            queue.add(neighbor);
        }

        private void markRenderer(CullInfo info, EntityLivingBase view) {
            WorldRenderer rend = this.render.field_72765_l[info.wrIdx];
            if (!rend.field_78936_t) {
                rend.field_78936_t = true;
                if (!rend.field_78935_u) {
                    this.render.field_72768_k[this.render.field_72751_K++] = rend;
                }
            }
            if (rend.field_78939_q || !rend.field_78915_A || info.visGraph.isRenderDirty()) {
                rend.field_78939_q = true;
                if (!rend.field_78915_A || rend.field_78939_q && rend.func_78912_a((Entity)view) <= 1128.0f) {
                    ((IRenderGlobal)this.render).pushWorkerRenderer(rend);
                }
            }
        }

        private boolean isInFrustum(CullInfo ci, Frustrum frustum) {
            if (this.isWRInFrustum[ci.wrIdx]) {
                ci.isFrustumCheckPending = true;
            } else {
                WorldRenderer wr = Minecraft.func_71410_x().field_71438_f.field_72765_l[ci.wrIdx];
                wr.func_78908_a((ICamera)frustum);
                this.isWRInFrustum[ci.wrIdx] = wr.field_78927_l;
            }
            return this.isWRInFrustum[ci.wrIdx];
        }

        static {
            DUMMY.computeVisibility();
        }

        public static class CullInfo {
            public static final RenderPosition[][] ALLOWED_STEPS = CullInfo.generateAllowedSteps();
            public int wrIdx;
            public CullInfo[] neighbors = new CullInfo[EnumFacing.values().length];
            public long[] vis;
            public VisGraph visGraph = RenderWorker.access$000();
            public RenderPosition dir;
            public byte facings;
            public int lastCullUpdateFrame;
            public boolean isFrustumCheckPending;

            private static RenderPosition[][] generateAllowedSteps() {
                RenderPosition[][] allowedSteps = new RenderPosition[(int)Math.pow(2.0, 6.0) + 1][];
                for (int xStep = -1; xStep <= 1; ++xStep) {
                    for (int yStep = -1; yStep <= 1; ++yStep) {
                        for (int zStep = -1; zStep <= 1; ++zStep) {
                            byte mask = 0;
                            mask = (byte)(mask | (new byte[]{4, 0, 8})[xStep + 1]);
                            mask = (byte)(mask | (new byte[]{1, 0, 2})[yStep + 1]);
                            byte finalMask = mask = (byte)(mask | (new byte[]{16, 0, 32})[zStep + 1]);
                            allowedSteps[mask] = (RenderPosition[])Stream.of(RenderPosition.DOWN, RenderPosition.UP, RenderPosition.NORTH, RenderPosition.SOUTH, RenderPosition.WEST, RenderPosition.EAST).filter(p -> (1 << p.getOpposite().ordinal() & finalMask) == 0).toArray(RenderPosition[]::new);
                        }
                    }
                }
                return allowedSteps;
            }

            public CullInfo() {
                this.vis = this.visGraph.getVisibilityArray();
            }

            public CullInfo init(RenderPosition dir, byte facings) {
                this.dir = dir;
                this.facings = facings;
                this.facings = (byte)(this.facings | 1 << dir.ordinal());
                return this;
            }

            public CullInfo getNeighbor(EnumFacing dir) {
                return this.neighbors[dir.ordinal()];
            }

            public void setNeighbor(EnumFacing dir, CullInfo neighbor) {
                this.neighbors[dir.ordinal()] = neighbor;
            }

            public boolean setLastCullUpdateFrame(int lastCullUpdateFrame) {
                if (this.lastCullUpdateFrame == lastCullUpdateFrame) {
                    return false;
                }
                this.lastCullUpdateFrame = lastCullUpdateFrame;
                return true;
            }
        }
    }
}

