/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.occlusion;

import net.minecraft.world.chunk.Chunk;
import org.embeddedt.archaicfix.occlusion.ICulledChunk;
import org.embeddedt.archaicfix.occlusion.OcclusionHelpers;
import org.embeddedt.archaicfix.occlusion.VisGraph;
import org.embeddedt.archaicfix.occlusion.util.LinkedHashList;
import org.embeddedt.archaicfix.occlusion.util.SynchronizedIdentityLinkedHashList;

public class ChunkThread
extends Thread {
    public LinkedHashList<Chunk> loaded = new SynchronizedIdentityLinkedHashList<Chunk>();
    public LinkedHashList<Chunk> modified = new SynchronizedIdentityLinkedHashList<Chunk>();

    public ChunkThread() {
        super("Chunk Worker");
    }

    @Override
    public void run() {
        while (true) {
            Chunk chunk;
            int i = 0;
            boolean work = false;
            while (this.loaded.size() > 0) {
                chunk = ((ICulledChunk)this.loaded.shift()).buildCulledSides();
                if (chunk != null) {
                    this.modified.add(chunk);
                    work = true;
                }
                if ((i & 3) == 0) {
                    ChunkThread.yield();
                }
                ++i;
            }
            i = 0;
            while (this.modified.size() > 0) {
                chunk = this.modified.shift();
                if (!this.loaded.contains(chunk)) {
                    for (VisGraph graph : ((ICulledChunk)chunk).getVisibility()) {
                        if (!graph.isDirty()) continue;
                        long a = graph.getVisibility();
                        graph.computeVisibility();
                        work |= a != graph.getVisibility();
                    }
                    if ((i & 7) == 0) {
                        ChunkThread.yield();
                    }
                }
                ++i;
            }
            OcclusionHelpers.worker.dirty = work;
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

