/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.FMLCommonHandler;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.WorldInfo;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.ducks.IArchaicWorld;
import org.embeddedt.archaicfix.lighting.world.lighting.LightingEngineHelpers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={World.class})
public abstract class MixinWorld
implements IArchaicWorld {
    @Shadow
    public boolean field_72995_K;
    @Shadow
    public EnumDifficulty field_73013_u;
    @Shadow
    protected WorldInfo field_72986_A;
    @Shadow
    public List field_73010_i;
    @Shadow
    protected IChunkProvider field_73020_y;
    @Shadow
    public List field_147482_g;
    private LongCollection tileEntitiesChunkToBeRemoved = new LongOpenHashSet();
    private Set<String> entityOptimizationIgnoreSet = null;

    @Shadow
    public abstract float func_130001_d();

    @Shadow
    public abstract Chunk func_72964_e(int var1, int var2);

    @Redirect(method={"getBiomeGenForCoordsBody"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/WorldChunkManager;getBiomeGenAt(II)Lnet/minecraft/world/biome/BiomeGenBase;"))
    private BiomeGenBase skipBiomeGenOnClient(WorldChunkManager manager, int x, int z) {
        if (this.field_72995_K) {
            return BiomeGenBase.field_76771_b;
        }
        return manager.func_76935_a(x, z);
    }

    @Inject(method={"func_147473_B"}, at={@At(value="HEAD")}, cancellable=true)
    public void func_147473_B(int p_147473_1_, int p_147473_2_, int p_147473_3_, CallbackInfoReturnable<Float> cir) {
        if (!ArchaicConfig.betterRegionalDifficulty) {
            return;
        }
        float factor = this.field_72986_A != null ? (float)this.field_72986_A.func_82573_f() / 7200000.0f : 0.0f;
        factor += this.func_130001_d() * 0.25f;
        EnumDifficulty difficulty = this.field_73013_u;
        if (difficulty == null) {
            difficulty = EnumDifficulty.NORMAL;
        }
        if (difficulty == EnumDifficulty.EASY || difficulty == EnumDifficulty.PEACEFUL) {
            factor *= 0.5f;
        } else if (difficulty == EnumDifficulty.HARD) {
            factor *= 2.0f;
        }
        cir.setReturnValue((Object)Float.valueOf(MathHelper.func_76131_a((float)factor, (float)0.0f, (float)((float)difficulty.func_151525_a() * 0.5f))));
    }

    @Inject(method={"updateEntityWithOptionalForce"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;lastTickPosX:D", ordinal=0)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void skipUpdateIfOptimizing(Entity entity, boolean force, CallbackInfo ci, int chunkX, int chunkZ, boolean isInForcedChunk) {
        EntityPlayer player;
        if (!ArchaicConfig.optimizeEntityTicking) {
            return;
        }
        if (this.entityOptimizationIgnoreSet == null) {
            this.entityOptimizationIgnoreSet = ImmutableSet.copyOf((Object[])ArchaicConfig.optimizeEntityTickingIgnoreList);
        }
        if (this.entityOptimizationIgnoreSet.contains(EntityList.func_75621_b((Entity)entity))) {
            return;
        }
        if (isInForcedChunk || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer) {
            return;
        }
        double finalDist = Double.MAX_VALUE;
        Iterator iterator = entity.field_70170_p.field_73010_i.iterator();
        while (iterator.hasNext() && !((finalDist = Math.min(finalDist, (player = (EntityPlayer)iterator.next()).func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) <= (double)ArchaicConfig.optimizeEntityTickingDistance)) {
        }
        if (((EntityLivingBase)entity).field_70725_aQ <= 0 && finalDist > (double)ArchaicConfig.optimizeEntityTickingDistance) {
            ci.cancel();
        }
    }

    @Inject(method={"setActivePlayerChunksAndCheckLight"}, at={@At(value="TAIL")})
    private void saveInactiveChunks(CallbackInfo ci) {
        if (this.field_72995_K || ArchaicConfig.optimizeBlockTickingDistance <= 0) {
            return;
        }
        int renderDistance = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72395_o();
        if (renderDistance <= ArchaicConfig.optimizeBlockTickingDistance) {
            return;
        }
        int activeDistance = ArchaicConfig.optimizeBlockTickingDistance;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)this.field_73010_i.get(i);
            int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int offX = -renderDistance; offX <= renderDistance; ++offX) {
                for (int offZ = -renderDistance; offZ <= renderDistance; ++offZ) {
                    Chunk chunk;
                    if (Math.abs(offX) <= activeDistance && Math.abs(offZ) <= activeDistance || (chunk = LightingEngineHelpers.getLoadedChunk(this.field_73020_y, offX + j, offZ + k)) == null || chunk.func_150802_k()) continue;
                    chunk.func_150804_b(false);
                }
            }
        }
    }

    @Override
    public void arch$markTileEntitiesInChunkForRemoval(Chunk chunk) {
        if (!chunk.field_150816_i.isEmpty()) {
            long pos = ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
            this.tileEntitiesChunkToBeRemoved.add(pos);
        }
    }

    @Inject(method={"updateEntities"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/world/World;field_147481_N:Z", ordinal=1)})
    private void removeInUnloaded(CallbackInfo ci) {
        if (ArchaicConfig.fixTEUnloadLag && !this.tileEntitiesChunkToBeRemoved.isEmpty()) {
            Predicate<TileEntity> isInChunk = tileEntity -> {
                long tileChunkPos = ChunkCoordIntPair.func_77272_a((int)(tileEntity.field_145851_c >> 4), (int)(tileEntity.field_145849_e >> 4));
                return this.tileEntitiesChunkToBeRemoved.contains(tileChunkPos);
            };
            Predicate<TileEntity> isInChunkDoUnload = tileEntity -> {
                boolean inChunk = isInChunk.test((TileEntity)tileEntity);
                if (inChunk) {
                    tileEntity.onChunkUnload();
                }
                return inChunk;
            };
            this.field_147482_g.removeIf(isInChunkDoUnload);
            this.tileEntitiesChunkToBeRemoved.clear();
        }
    }
}

