/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnerAnimals.class})
public class MixinSpawnerAnimals {
    @Shadow
    private HashMap field_77193_b;

    @ModifyConstant(method={"findChunksForSpawning"}, constant={@Constant(doubleValue=24.0)})
    private double lowerSpawnRange(double old) {
        return ArchaicConfig.fixMobSpawnsAtLowRenderDist ? 16.0 : old;
    }

    @Redirect(method={"performWorldGenSpawning"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntityInWorld(Lnet/minecraft/entity/Entity;)Z"))
    private static boolean checkForCollision(World world, Entity instance) {
        if (!ArchaicConfig.preventEntitySuffocationWorldgen || world.func_72945_a(instance, instance.field_70121_D).isEmpty()) {
            return world.func_72838_d(instance);
        }
        return false;
    }

    @Inject(method={"findChunksForSpawning"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getSpawnPoint()Lnet/minecraft/util/ChunkCoordinates;", ordinal=0)})
    private void removeUnloadedChunks(WorldServer p_77192_1_, boolean p_77192_2_, boolean p_77192_3_, boolean p_77192_4_, CallbackInfoReturnable<Integer> cir) {
        if (!ArchaicConfig.lazyChunkLoading) {
            return;
        }
        Iterator eligibleChunks = this.field_77193_b.keySet().iterator();
        IChunkProvider prov = p_77192_1_.func_72863_F();
        while (eligibleChunks.hasNext()) {
            ChunkCoordIntPair pair = (ChunkCoordIntPair)eligibleChunks.next();
            if (prov.func_73149_a(pair.field_77276_a, pair.field_77275_b)) continue;
            eligibleChunks.remove();
        }
    }
}

