/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Kepler22b.worldgen;

import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.BiomeDecoratorKepler22b;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bBlueMapleForest;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bCoalPlains;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bDiamondPlains;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bEmeraldPlains;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bGoldPlains;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bIronPlains;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bPlains;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bPurpleMapleForest;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bRedDesert;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bRedMapleForest;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bWasteLands;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.biome.BiomeGenKepler22bYellowMapleForest;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;

public class Kepler22bBiomes
extends BiomeGenBase {
    public static final BiomeGenBase kepler22bPlains = new BiomeGenKepler22bPlains().func_76739_b(112).func_76735_a("Kepler22b Plains").func_150570_a(field_150593_e);
    public static final BiomeGenBase kepler22bBlueForest = new BiomeGenKepler22bBlueMapleForest().func_76739_b(112).func_76735_a("Kepler22b Blue Maple Forest").func_150570_a(field_150593_e);
    public static final BiomeGenBase kepler22bPurpleForest = new BiomeGenKepler22bPurpleMapleForest().func_76739_b(112).func_76735_a("Kepler22b Purple Maple Forest").func_150570_a(field_150593_e);
    public static final BiomeGenBase kepler22bRedForest = new BiomeGenKepler22bRedMapleForest().func_76739_b(112).func_76735_a("Kepler22b Red Maple Forest").func_150570_a(field_150593_e);
    public static final BiomeGenBase kepler22bYellowForest = new BiomeGenKepler22bYellowMapleForest().func_76739_b(112).func_76735_a("Kepler22b Yellow Maple Forest").func_150570_a(field_150593_e);
    public static final BiomeGenBase kepler22bRedDesert = new BiomeGenKepler22bRedDesert().func_76739_b(112).func_76735_a("Kepler22b Red Desert").func_150570_a(field_150603_i);
    public static final BiomeGenBase kepler22bWasteLands = new BiomeGenKepler22bWasteLands().func_76739_b(112).func_76735_a("Kepler22b Waste Lands").func_150570_a(new BiomeGenBase.Height(-0.2f, 0.1f));
    public static final BiomeGenBase kepler22bDiamondPlains = new BiomeGenKepler22bDiamondPlains().func_76735_a("Kepler22b Diamond Plains").func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static final BiomeGenBase kepler22bCoalPlains = new BiomeGenKepler22bCoalPlains().func_76735_a("Kepler22b Coal Plains").func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static final BiomeGenBase kepler22bIronPlains = new BiomeGenKepler22bIronPlains().func_76735_a("Kepler22b Iron Plains").func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static final BiomeGenBase kepler22bGoldPlains = new BiomeGenKepler22bGoldPlains().func_76735_a("Kepler22b Gold Plains").func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static final BiomeGenBase kepler22bEmeraldPlains = new BiomeGenKepler22bEmeraldPlains().func_76735_a("Kepler22b Emerald Plains").func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    protected Block stoneBlock;
    protected byte topMeta;
    protected byte fillerMeta;
    protected byte stoneMeta;

    public Kepler22bBiomes(int id) {
        super(id);
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76751_G = 0.0f;
        this.func_76739_b(-16744448);
        this.field_76765_S = true;
        this.field_76766_R = true;
        this.field_76752_A = ExtraPlanets_Blocks.kepler22bGrass;
        this.topMeta = 0;
        this.field_76753_B = ExtraPlanets_Blocks.kepler22bBlocks;
        this.fillerMeta = 0;
        this.stoneBlock = ExtraPlanets_Blocks.kepler22bBlocks;
        this.stoneMeta = 1;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorKepler22b();
    }

    protected BiomeDecoratorKepler22b getBiomeDecorator() {
        return (BiomeDecoratorKepler22b)this.field_76760_I;
    }

    public boolean func_76738_d() {
        return this.func_150559_j() ? false : this.field_76765_S;
    }

    public void func_150573_a(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        this.generateBiomeTerrain(world, rand, block, meta, x, z, stoneNoise);
    }

    public void generateBiomeTerrain(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        Block topBlock = this.field_76752_A;
        byte topMeta = this.topMeta;
        Block fillerBlock = this.field_76753_B;
        byte fillerMeta = this.fillerMeta;
        int currentFillerDepth = -1;
        int maxFillerDepth = (int)(stoneNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int maskX = x & 0xF;
        int maskZ = z & 0xF;
        int worldHeight = block.length / 256;
        int seaLevel = 32;
        for (int y = 255; y >= 0; --y) {
            int index = (maskZ * 16 + maskX) * worldHeight + y;
            if (y <= 0 + rand.nextInt(5)) {
                block[index] = Blocks.field_150357_h;
                continue;
            }
            Block currentBlock = block[index];
            if (currentBlock == null || currentBlock.func_149688_o() == Material.field_151579_a || currentBlock != Blocks.field_150348_b) continue;
            if (this.stoneBlock != null) {
                block[index] = this.stoneBlock;
                meta[index] = this.stoneMeta;
            }
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topBlock = null;
                    topMeta = 0;
                    fillerBlock = ExtraPlanets_Blocks.kepler22bBlocks;
                    fillerMeta = 1;
                } else if (y >= seaLevel - 5 && y <= seaLevel) {
                    topBlock = this.field_76752_A;
                    topMeta = this.topMeta;
                    fillerBlock = this.field_76753_B;
                    fillerMeta = 0;
                }
                if (y < seaLevel - 1 && (topBlock == null || topBlock.func_149688_o() == Material.field_151579_a)) {
                    if (this.func_150564_a(x, y, z) < 0.15f) {
                        topBlock = Blocks.field_150432_aD;
                        topMeta = 0;
                    } else {
                        topBlock = Blocks.field_150355_j;
                        topMeta = 0;
                    }
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= seaLevel - 2) {
                    block[index] = topBlock;
                    meta[index] = topMeta;
                    continue;
                }
                if (y < seaLevel - 8 - maxFillerDepth) {
                    topBlock = null;
                    fillerBlock = ExtraPlanets_Blocks.kepler22bBlocks;
                    fillerMeta = 1;
                    block[index] = Blocks.field_150351_n;
                    continue;
                }
                block[index] = fillerBlock;
                meta[index] = fillerMeta;
                continue;
            }
            if (currentFillerDepth <= 0) continue;
            block[index] = fillerBlock;
            meta[index] = fillerMeta;
            if (--currentFillerDepth != 0 || fillerBlock != Blocks.field_150354_m) continue;
            currentFillerDepth = rand.nextInt(4) + Math.max(0, y - (seaLevel - 1));
            fillerBlock = Blocks.field_150322_A;
            fillerMeta = 0;
        }
    }

    public BiomeGenBase func_76739_b(int var1) {
        return super.func_76739_b(var1);
    }

    public float func_76741_f() {
        return 0.1f;
    }
}

