/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanets_SolarSystems;
import com.mjr.extraplanets.planets.Ceres.TeleportTypeCeres;
import com.mjr.extraplanets.planets.Ceres.WorldProviderCeres;
import com.mjr.extraplanets.planets.Eris.TeleportTypeEris;
import com.mjr.extraplanets.planets.Eris.WorldProviderEris;
import com.mjr.extraplanets.planets.Jupiter.TeleportTypeJupiter;
import com.mjr.extraplanets.planets.Jupiter.WorldProviderJupiter;
import com.mjr.extraplanets.planets.Kepler22b.TeleportTypeKepler22b;
import com.mjr.extraplanets.planets.Kepler22b.WorldProviderKepler22b;
import com.mjr.extraplanets.planets.Mercury.TeleportTypeMercury;
import com.mjr.extraplanets.planets.Mercury.WorldProviderMercury;
import com.mjr.extraplanets.planets.Neptune.TeleportTypeNeptune;
import com.mjr.extraplanets.planets.Neptune.WorldProviderNeptune;
import com.mjr.extraplanets.planets.Pluto.TeleportTypePluto;
import com.mjr.extraplanets.planets.Pluto.WorldProviderPluto;
import com.mjr.extraplanets.planets.Saturn.TeleportTypeSaturn;
import com.mjr.extraplanets.planets.Saturn.WorldProviderSaturn;
import com.mjr.extraplanets.planets.Uranus.TeleportTypeUranus;
import com.mjr.extraplanets.planets.Uranus.WorldProviderUranus;
import com.mjr.extraplanets.planets.Venus.TeleportTypeVenus;
import com.mjr.extraplanets.planets.Venus.WorldProviderVenus;
import com.mjr.extraplanets.util.RegisterHelper;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.util.ResourceLocation;

public class ExtraPlanets_Planets {
    public static Planet mercury;
    public static Planet venus;
    public static Planet ceres;
    public static Planet jupiter;
    public static Planet saturn;
    public static Planet uranus;
    public static Planet neptune;
    public static Planet pluto;
    public static Planet haumea;
    public static Planet eris;
    public static Planet kuiperBelt;
    public static Planet makemake;
    public static Planet kepler22b;
    public static Planet kepler47b;
    public static Planet kepler47c;
    public static Planet kepler62b;
    public static Planet kepler62c;
    public static Planet kepler62d;
    public static Planet kepler62e;
    public static Planet kepler62f;
    public static Planet kepler69b;
    public static Planet kepler69c;
    public static boolean mercuryOverride;
    public static boolean venusOverride;
    public static boolean ceresOverride;
    public static boolean jupiterOverride;
    public static boolean saturnOverride;
    public static boolean uranusOverride;
    public static boolean neptuneOverride;
    public static boolean plutoOverride;
    public static boolean erisOverrides;
    public static boolean kepler22bOverride;

    public static void init() {
        ExtraPlanets_Planets.initializePlanets();
        ExtraPlanets_Planets.registerPlanets();
        ExtraPlanets_Planets.initializeUnReachablePlanets();
    }

    private static void initializePlanets() {
        if (Config.mercury) {
            mercury = new Planet(mercuryOverride ? "MercuryEP" : "Mercury").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            mercury.setTierRequired(Config.mercuryRocketTier);
            mercury.setRingColorRGB(0.1f, 0.9f, 0.6f);
            mercury.setPhaseShift(1.45f);
            mercury.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f + Config.mercuryDistanceOffset, 0.5f + Config.mercuryDistanceOffset));
            mercury.setRelativeOrbitTime(0.24096386f);
            mercury.atmosphereComponent(IAtmosphericGas.HYDROGEN);
            mercury.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/mercury.png"));
            mercury.setDimensionInfo(Config.mercuryID, WorldProviderMercury.class);
        }
        if (Config.venus) {
            venus = new Planet(venusOverride ? "VenusEP" : "Venus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            venus.setTierRequired(3);
            venus.setRingColorRGB(0.1f, 0.9f, 0.6f);
            venus.setPhaseShift(2.0f);
            venus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f + Config.venusDistanceOffset, 0.75f + Config.venusDistanceOffset));
            venus.setRelativeOrbitTime(0.6152793f);
            venus.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.CO2);
            venus.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/venus.png"));
            venus.setDimensionInfo(Config.venusID, WorldProviderVenus.class);
        }
        if (Config.ceres) {
            ceres = new Planet(ceresOverride ? "CeresEp" : "Ceres").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            ceres.setTierRequired(Config.ceresRocketTier);
            ceres.setRingColorRGB(0.1f, 0.9f, 0.6f);
            ceres.setPhaseShift((float)Math.PI);
            ceres.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f + Config.ceresDistanceOffset, 1.5f + Config.ceresDistanceOffset));
            ceres.setRelativeOrbitTime(5.930997f);
            ceres.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM);
            ceres.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/ceres.png"));
            ceres.setDimensionInfo(Config.ceresID, WorldProviderCeres.class);
        }
        if (Config.jupiter) {
            jupiter = new Planet(jupiterOverride ? "JupiterEP" : "Jupiter").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            jupiter.setTierRequired(4);
            jupiter.setRingColorRGB(0.1f, 0.9f, 0.6f);
            jupiter.setPhaseShift((float)Math.PI);
            jupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f + Config.jupiterDistanceOffset, 1.75f + Config.jupiterDistanceOffset));
            jupiter.setRelativeOrbitTime(11.861994f);
            jupiter.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM);
            jupiter.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/jupiter.png"));
            jupiter.setDimensionInfo(Config.jupiterID, WorldProviderJupiter.class);
        }
        if (Config.saturn) {
            saturn = new Planet(saturnOverride ? "SaturnEP" : "Saturn").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            if (Config.morePlanetsCompatibilityAdv143) {
                saturn.setTierRequired(4);
            } else {
                saturn.setTierRequired(5);
            }
            saturn.setRingColorRGB(0.1f, 0.9f, 0.6f);
            saturn.setPhaseShift(5.45f);
            saturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f + Config.saturnDistanceOffset, 2.0f + Config.saturnDistanceOffset));
            saturn.setRelativeOrbitTime(29.463308f);
            saturn.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            saturn.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/saturn.png"));
            saturn.setDimensionInfo(Config.saturnID, WorldProviderSaturn.class);
        }
        if (Config.uranus) {
            uranus = new Planet(uranusOverride ? "UranusEP" : "Uranus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            if (Config.morePlanetsCompatibilityAdv143) {
                uranus.setTierRequired(4);
            } else {
                uranus.setTierRequired(6);
            }
            uranus.setRingColorRGB(0.1f, 0.9f, 0.6f);
            uranus.setPhaseShift(1.38f);
            uranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.25f + Config.uranusDistanceOffset, 2.25f + Config.uranusDistanceOffset));
            uranus.setRelativeOrbitTime(84.06353f);
            uranus.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE).atmosphereComponent(IAtmosphericGas.WATER);
            uranus.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/uranus.png"));
            uranus.setDimensionInfo(Config.uranusID, WorldProviderUranus.class);
        }
        if (Config.neptune) {
            neptune = new Planet(neptuneOverride ? "NeptuneEP" : "Neptune").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            if (Config.morePlanetsCompatibilityAdv143) {
                neptune.setTierRequired(5);
            } else {
                neptune.setTierRequired(7);
            }
            neptune.setRingColorRGB(0.1f, 0.9f, 0.6f);
            neptune.setPhaseShift(1.0f);
            neptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f + Config.neptuneDistanceOffset, 2.5f + Config.neptuneDistanceOffset));
            neptune.setRelativeOrbitTime(164.84119f);
            neptune.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.WATER);
            neptune.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/neptune.png"));
            neptune.setDimensionInfo(Config.neptuneID, WorldProviderNeptune.class);
        }
        if (Config.pluto) {
            pluto = new Planet(plutoOverride ? "PlutoEP" : "Pluto").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            pluto.setTierRequired(8);
            pluto.setRingColorRGB(0.1f, 0.9f, 0.6f);
            pluto.setPhaseShift(2.0f);
            pluto.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.75f + Config.plutoDistanceOffset, 2.75f + Config.plutoDistanceOffset));
            pluto.setRelativeOrbitTime(329.68237f);
            pluto.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.WATER);
            pluto.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/pluto.png"));
            pluto.setDimensionInfo(Config.plutoID, WorldProviderPluto.class);
        }
        if (Config.eris) {
            eris = new Planet(erisOverrides ? "ErisEP" : "Eris").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            if (Config.morePlanetsCompatibilityAdv143) {
                eris.setTierRequired(6);
            } else {
                eris.setTierRequired(Config.morePlanetsCompatibility ? 8 : 9);
            }
            eris.setRingColorRGB(0.1f, 0.9f, 0.6f);
            eris.setPhaseShift(1.0f);
            eris.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.5f + Config.erisDistanceOffset, 3.5f + Config.erisDistanceOffset));
            eris.setRelativeOrbitTime(494.52356f);
            eris.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.WATER);
            eris.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/eris.png"));
            eris.setDimensionInfo(Config.erisID, WorldProviderEris.class);
        }
        if (Config.kepler22b && Config.keplerSolarSystems) {
            kepler22b = new Planet("kepler22b").setParentSolarSystem(ExtraPlanets_SolarSystems.kepler22);
            if (Config.morePlanetsCompatibilityAdv143) {
                kepler22b.setTierRequired(7);
            } else {
                kepler22b.setTierRequired(Config.morePlanetsCompatibility ? 8 : 10);
            }
            kepler22b.setRingColorRGB(0.1f, 0.9f, 0.6f);
            kepler22b.setPhaseShift(1.45f);
            kepler22b.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
            kepler22b.setRelativeOrbitTime(164.84119f);
            kepler22b.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.WATER).atmosphereComponent(IAtmosphericGas.OXYGEN);
            kepler22b.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler22b.png"));
            kepler22b.setDimensionInfo(Config.kepler22bID, WorldProviderKepler22b.class);
        }
    }

    public static void initializeUnReachablePlanets() {
        if (Config.kuiperBelt) {
            kuiperBelt = RegisterHelper.registerUnreachablePlanet("kuiperBelt", GalacticraftCore.solarSystemSol);
            if (kuiperBelt != null) {
                kuiperBelt.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.0f + Config.kuiperBeltDistanceOffset, 4.0f + Config.kuiperBeltDistanceOffset)).setRelativeOrbitTime(164.84119f);
            }
            kuiperBelt.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kuiper_belt.png"));
        }
        if (Config.makemake) {
            makemake = RegisterHelper.registerUnreachablePlanet("makemake", GalacticraftCore.solarSystemSol);
            if (makemake != null) {
                makemake.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.5f + Config.makemakeDistanceOffset, 4.5f + Config.makemakeDistanceOffset)).setRelativeOrbitTime(164.84119f);
            }
            makemake.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/makemake.png"));
        }
        if (Config.haumea) {
            haumea = RegisterHelper.registerUnreachablePlanet("haumea", GalacticraftCore.solarSystemSol);
            if (haumea != null) {
                haumea.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.5f + Config.haumeaDistanceOffset, 3.5f + Config.haumeaDistanceOffset)).setRelativeOrbitTime(164.84119f);
            }
            haumea.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/haumea.png"));
        }
        if (Config.keplerSolarSystems) {
            kepler47b = RegisterHelper.registerUnreachablePlanet("kepler47b", ExtraPlanets_SolarSystems.kepler47);
            if (kepler47b != null) {
                kepler47b.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(164.84119f);
            }
            kepler47b.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler47b.png"));
            kepler47c = RegisterHelper.registerUnreachablePlanet("kepler47c", ExtraPlanets_SolarSystems.kepler47);
            if (kepler47c != null) {
                kepler47c.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(164.84119f);
            }
            kepler47c.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler47c.png"));
            kepler62b = RegisterHelper.registerUnreachablePlanet("kepler62b", ExtraPlanets_SolarSystems.kepler62);
            if (kepler62b != null) {
                kepler62b.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(0.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(27.473532f);
            }
            kepler62b.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62b.png"));
            kepler62c = RegisterHelper.registerUnreachablePlanet("kepler62c", ExtraPlanets_SolarSystems.kepler62);
            if (kepler62c != null) {
                kepler62c.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(32.96824f);
            }
            kepler62c.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62c.png"));
            kepler62d = RegisterHelper.registerUnreachablePlanet("kepler62d", ExtraPlanets_SolarSystems.kepler62);
            if (kepler62d != null) {
                kepler62d.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f)).setRelativeOrbitTime(41.210297f);
            }
            kepler62d.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62d.png"));
            kepler62e = RegisterHelper.registerUnreachablePlanet("kepler62e", ExtraPlanets_SolarSystems.kepler62);
            if (kepler62e != null) {
                kepler62e.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(3.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f)).setRelativeOrbitTime(54.947063f);
            }
            kepler62e.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62e.png"));
            kepler62f = RegisterHelper.registerUnreachablePlanet("kepler62f", ExtraPlanets_SolarSystems.kepler62);
            if (kepler62f != null) {
                kepler62f.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(4.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f)).setRelativeOrbitTime(82.42059f);
            }
            kepler62f.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62f.png"));
            kepler69b = RegisterHelper.registerUnreachablePlanet("kepler69b", ExtraPlanets_SolarSystems.kepler69);
            if (kepler69b != null) {
                kepler69b.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(164.84119f);
            }
            kepler69b.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler69b.png"));
            kepler69c = RegisterHelper.registerUnreachablePlanet("kepler69c", ExtraPlanets_SolarSystems.kepler69);
            if (kepler69c != null) {
                kepler69c.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(6.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(164.84119f);
            }
            kepler69c.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler69c.png"));
        }
    }

    private static void registerPlanets() {
        if (Config.mercury) {
            GalaxyRegistry.registerPlanet((Planet)mercury);
            GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new TeleportTypeMercury());
            GalacticraftRegistry.registerRocketGui(WorldProviderMercury.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/mercury_rocket_gui.png"));
        }
        if (Config.venus) {
            GalaxyRegistry.registerPlanet((Planet)venus);
            GalacticraftRegistry.registerTeleportType(WorldProviderVenus.class, (ITeleportType)new TeleportTypeVenus());
            GalacticraftRegistry.registerRocketGui(WorldProviderVenus.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/venus_rocket_gui.png"));
        }
        if (Config.ceres) {
            GalaxyRegistry.registerPlanet((Planet)ceres);
            GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeCeres());
            GalacticraftRegistry.registerRocketGui(WorldProviderCeres.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/ceres_rocket_gui.png"));
        }
        if (Config.jupiter) {
            GalaxyRegistry.registerPlanet((Planet)jupiter);
            GalacticraftRegistry.registerTeleportType(WorldProviderJupiter.class, (ITeleportType)new TeleportTypeJupiter());
            GalacticraftRegistry.registerRocketGui(WorldProviderJupiter.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/jupiter_rocket_gui.png"));
        }
        if (Config.saturn) {
            GalaxyRegistry.registerPlanet((Planet)saturn);
            GalacticraftRegistry.registerTeleportType(WorldProviderSaturn.class, (ITeleportType)new TeleportTypeSaturn());
            GalacticraftRegistry.registerRocketGui(WorldProviderSaturn.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/saturn_rocket_gui.png"));
        }
        if (Config.uranus) {
            GalaxyRegistry.registerPlanet((Planet)uranus);
            GalacticraftRegistry.registerTeleportType(WorldProviderUranus.class, (ITeleportType)new TeleportTypeUranus());
            GalacticraftRegistry.registerRocketGui(WorldProviderUranus.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/uranus_rocket_gui.png"));
        }
        if (Config.neptune) {
            GalaxyRegistry.registerPlanet((Planet)neptune);
            GalacticraftRegistry.registerTeleportType(WorldProviderNeptune.class, (ITeleportType)new TeleportTypeNeptune());
            GalacticraftRegistry.registerRocketGui(WorldProviderNeptune.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/neptune_rocket_gui.png"));
        }
        if (Config.pluto) {
            GalaxyRegistry.registerPlanet((Planet)pluto);
            GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new TeleportTypePluto());
            GalacticraftRegistry.registerRocketGui(WorldProviderPluto.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/pluto_rocket_gui.png"));
        }
        if (Config.eris) {
            GalaxyRegistry.registerPlanet((Planet)eris);
            GalacticraftRegistry.registerTeleportType(WorldProviderEris.class, (ITeleportType)new TeleportTypeEris());
            GalacticraftRegistry.registerRocketGui(WorldProviderEris.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/eris_rocket_gui.png"));
        }
        if (Config.kepler22b && Config.keplerSolarSystems) {
            GalaxyRegistry.registerPlanet((Planet)kepler22b);
            GalacticraftRegistry.registerTeleportType(WorldProviderKepler22b.class, (ITeleportType)new TeleportTypeKepler22b());
            GalacticraftRegistry.registerRocketGui(WorldProviderKepler22b.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/kepler22b_rocket_gui.png"));
        }
    }
}

