/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaser
extends TileEntityNoisyElectricBlock
implements IActiveState {
    public Coord4D digging;
    public double diggingProgress;
    public boolean isActive;
    public boolean clientActive;

    public TileEntityLaser() {
        super("machine.laser", "Laser", 2.0 * MekanismConfig.usage.laserUsage);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            if (this.isActive) {
                Coord4D hitCoord;
                MovingObjectPosition mop = LaserManager.fireLaserClient(this, ForgeDirection.getOrientation((int)this.facing), MekanismConfig.usage.laserUsage, this.field_145850_b);
                Coord4D coord4D = hitCoord = mop == null ? null : new Coord4D(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, this.field_145850_b.field_73011_w.field_76574_g);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    Block blockHit = hitCoord.getBlock((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_149712_f(this.field_145850_b, hitCoord.xCoord, hitCoord.yCoord, hitCoord.zCoord);
                    if (!(hardness < 0.0f || tileHit instanceof ILaserReceptor && !((ILaserReceptor)tileHit).canLasersDig())) {
                        this.diggingProgress += MekanismConfig.usage.laserUsage;
                        if (this.diggingProgress < (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                            Mekanism.proxy.addHitEffects(hitCoord, mop);
                        }
                    }
                }
            }
        } else if (this.getEnergy() >= MekanismConfig.usage.laserUsage) {
            Coord4D hitCoord;
            this.setActive(true);
            LaserManager.LaserInfo info = LaserManager.fireLaser(this, ForgeDirection.getOrientation((int)this.facing), MekanismConfig.usage.laserUsage, this.field_145850_b);
            Coord4D coord4D = hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos.field_72311_b, info.movingPos.field_72312_c, info.movingPos.field_72309_d, this.field_145850_b.field_73011_w.field_76574_g);
            if (hitCoord == null || !hitCoord.equals(this.digging)) {
                this.digging = hitCoord;
                this.diggingProgress = 0.0;
            }
            if (hitCoord != null) {
                Block blockHit = hitCoord.getBlock((IBlockAccess)this.field_145850_b);
                TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                float hardness = blockHit.func_149712_f(this.field_145850_b, hitCoord.xCoord, hitCoord.yCoord, hitCoord.zCoord);
                if (!(hardness < 0.0f || tileHit instanceof ILaserReceptor && !((ILaserReceptor)tileHit).canLasersDig())) {
                    this.diggingProgress += MekanismConfig.usage.laserUsage;
                    if (this.diggingProgress >= (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                        LaserManager.breakBlock(hitCoord, true, this.field_145850_b);
                        this.diggingProgress = 0.0;
                    }
                }
            }
            this.setEnergy(this.getEnergy() - MekanismConfig.usage.laserUsage);
        } else {
            this.setActive(false);
            this.diggingProgress = 0.0;
        }
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing).getOpposite());
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.isActive = dataStream.readBoolean();
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }
}

