/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import java.util.Iterator;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.util.StackUtils;
import mekanism.common.InfuseStorage;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public interface IFactory {
    public int getRecipeType(ItemStack var1);

    public void setRecipeType(int var1, ItemStack var2);

    public static enum RecipeType {
        SMELTING("Smelting", "smelter", BlockMachine.MachineType.ENERGIZED_SMELTER.getStack(), false, false, RecipeHandler.Recipe.ENERGIZED_SMELTER),
        ENRICHING("Enriching", "enrichment", BlockMachine.MachineType.ENRICHMENT_CHAMBER.getStack(), false, false, RecipeHandler.Recipe.ENRICHMENT_CHAMBER),
        CRUSHING("Crushing", "crusher", BlockMachine.MachineType.CRUSHER.getStack(), false, false, RecipeHandler.Recipe.CRUSHER),
        COMPRESSING("Compressing", "compressor", BlockMachine.MachineType.OSMIUM_COMPRESSOR.getStack(), true, false, RecipeHandler.Recipe.OSMIUM_COMPRESSOR),
        COMBINING("Combining", "combiner", BlockMachine.MachineType.COMBINER.getStack(), true, false, RecipeHandler.Recipe.COMBINER),
        PURIFYING("Purifying", "purifier", BlockMachine.MachineType.PURIFICATION_CHAMBER.getStack(), true, true, RecipeHandler.Recipe.PURIFICATION_CHAMBER),
        INJECTING("Injecting", "injection", BlockMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.getStack(), true, true, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER),
        INFUSING("Infusing", "metalinfuser", BlockMachine.MachineType.METALLURGIC_INFUSER.getStack(), false, false, RecipeHandler.Recipe.METALLURGIC_INFUSER);

        private String name;
        private ResourceLocation sound;
        private ItemStack stack;
        private boolean usesFuel;
        private boolean fuelSpeed;
        private RecipeHandler.Recipe recipe;
        private TileEntityAdvancedElectricMachine cacheTile;

        public BasicMachineRecipe getRecipe(ItemStackInput input) {
            return RecipeHandler.getRecipe(input, this.recipe.get());
        }

        public BasicMachineRecipe getRecipe(ItemStack input) {
            return this.getRecipe(new ItemStackInput(input));
        }

        public AdvancedMachineRecipe getRecipe(AdvancedMachineInput input) {
            return RecipeHandler.getRecipe(input, this.recipe.get());
        }

        public AdvancedMachineRecipe getRecipe(ItemStack input, Gas gas) {
            return this.getRecipe(new AdvancedMachineInput(input, gas));
        }

        public MetallurgicInfuserRecipe getRecipe(InfusionInput input) {
            return RecipeHandler.getMetallurgicInfuserRecipe(input);
        }

        public MetallurgicInfuserRecipe getRecipe(ItemStack input, InfuseStorage storage) {
            return this.getRecipe(new InfusionInput(storage, input));
        }

        public MachineRecipe getAnyRecipe(ItemStack slotStack, Gas gasType, InfuseStorage infuse) {
            if (this.usesFuel()) {
                return this.getRecipe(slotStack, gasType);
            }
            if (this == INFUSING) {
                if (infuse.type != null) {
                    return RecipeHandler.getMetallurgicInfuserRecipe(new InfusionInput(infuse, slotStack));
                }
                Iterator iterator = RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    InfusionInput input = (InfusionInput)entry.getKey();
                    if (!input.inputStack.func_77969_a(slotStack)) continue;
                    return (MetallurgicInfuserRecipe)entry.getValue();
                }
            }
            return this.getRecipe(slotStack);
        }

        public GasStack getItemGas(ItemStack itemstack) {
            if (this.usesFuel) {
                return this.getTile().getItemGas(itemstack);
            }
            return null;
        }

        public int getSecondaryEnergyPerTick() {
            if (this.usesFuel) {
                return this.getTile().BASE_SECONDARY_ENERGY_PER_TICK;
            }
            return 0;
        }

        public boolean canReceiveGas(ForgeDirection side, Gas type) {
            if (this.usesFuel) {
                return this.getTile().canReceiveGas(side, type);
            }
            return false;
        }

        public boolean canTubeConnect(ForgeDirection side) {
            if (this.usesFuel) {
                return this.getTile().canTubeConnect(side);
            }
            return false;
        }

        public boolean isValidGas(Gas gas) {
            if (this.usesFuel) {
                return this.getTile().isValidGas(gas);
            }
            return false;
        }

        public boolean hasRecipe(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            for (Map.Entry obj : this.recipe.get().entrySet()) {
                if (!(obj.getKey() instanceof AdvancedMachineInput)) continue;
                Map.Entry entry = obj;
                ItemStack stack = ((AdvancedMachineInput)entry.getKey()).itemStack;
                if (!StackUtils.equalsWildcard(stack, itemStack)) continue;
                return true;
            }
            return false;
        }

        public TileEntityAdvancedElectricMachine getTile() {
            if (this.cacheTile == null) {
                BlockMachine.MachineType type = BlockMachine.MachineType.get(Block.func_149634_a((Item)this.getStack().func_77973_b()), this.getStack().func_77960_j());
                this.cacheTile = (TileEntityAdvancedElectricMachine)type.create();
            }
            return this.cacheTile;
        }

        public int getMaxSecondaryEnergy() {
            return 200;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public String getLocalizedName() {
            return LangUtils.localize("gui.factory." + this.name);
        }

        public ResourceLocation getSound() {
            return this.sound;
        }

        public boolean usesFuel() {
            return this.usesFuel;
        }

        public boolean fuelEnergyUpgrades() {
            return this.fuelSpeed;
        }

        public static RecipeType getFromMachine(Block block, int meta) {
            RecipeType type = null;
            for (RecipeType iterType : RecipeType.values()) {
                ItemStack machineStack = iterType.getStack();
                if (Block.func_149634_a((Item)machineStack.func_77973_b()) != block || machineStack.func_77960_j() != meta) continue;
                type = iterType;
                break;
            }
            return type;
        }

        private RecipeType(String s, String s1, ItemStack is, boolean b, boolean b1, RecipeHandler.Recipe r) {
            this.name = s;
            this.sound = new ResourceLocation("mekanism", "tile.machine." + s1);
            this.stack = is;
            this.usesFuel = b;
            this.fuelSpeed = b1;
            this.recipe = r;
        }
    }
}

