/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    private int data;
    private int index = -1;

    public BitInputStream(InputStream input) {
        super(input);
    }

    public int readBit() throws IOException {
        if (this.index < 0) {
            this.data = this.in.read();
            if (this.data < 0) {
                throw new EOFException();
            }
            this.index = 6;
            return this.data >> 7 & 1;
        }
        --this.index;
        return this.data >> this.index + 1 & 1;
    }

    public boolean readBoolean() throws IOException {
        return this.readBit() == 1;
    }

    @Override
    public int read() throws IOException {
        int result = 0;
        for (int i = 0; i < 8; ++i) {
            int cur = this.readBit();
            result <<= 1;
            result |= cur;
        }
        return result;
    }

    public long readL(int bits) throws IOException {
        if (bits < 0) {
            throw new IllegalArgumentException("Cannot read negative bits. (" + bits + ")");
        }
        if (bits == 0) {
            return 0L;
        }
        if (bits > 64) {
            throw new IllegalArgumentException("Cannot fit " + bits + " into a long.");
        }
        long result = 0L;
        for (int i = 0; i < bits; ++i) {
            int cur = this.readBit();
            result <<= 1;
            result |= (long)cur;
        }
        return result;
    }

    public int read(int bits) throws IOException {
        if (bits > 32) {
            throw new IllegalArgumentException("Cannot fit " + bits + " into an int.");
        }
        return (int)this.readL(bits);
    }

    public int readSAM(int bits) throws IOException {
        boolean s = this.readBoolean();
        int v = this.read(bits);
        return s ? -v : v;
    }

    public float readSAMUnit(int bits) throws IOException {
        boolean s = this.readBoolean();
        int v = this.read(bits);
        int max = (1 << bits) - 1;
        float f = (float)v / (float)max;
        if (s) {
            f = -f;
        }
        return f;
    }

    public float readUnit(int bits) throws IOException {
        return (float)this.read(bits) / (float)((1 << bits) - 1);
    }

    public void align() throws IOException {
        while (this.index > 0) {
            this.readBit();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

