/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.bugfixmod.coremod;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.bugfixmod.BugfixModSettings;
import pl.asie.foamfix.bugfixmod.coremod.MappingRegistry;
import pl.asie.foamfix.bugfixmod.coremod.patchers.AbstractPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.BoatDesyncFixPatcher_Extra;
import pl.asie.foamfix.bugfixmod.coremod.patchers.BoatDesyncFixPatcher_Main;
import pl.asie.foamfix.bugfixmod.coremod.patchers.ChickenLureTweakPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.HeartBlinkFixPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.HeartFlashFixPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.ItemHopperBounceFixPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.ItemStairBounceFixPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.SnowballFixPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.VillageAnvilTweakPatcher;
import pl.asie.foamfix.coremod.patchers.FileRCEPatcher;
import pl.asie.foamfix.coremod.patchers.GhostBusterEarlyReturnPatcher;
import pl.asie.foamfix.coremod.patchers.GhostBusterHookPatcher;
import pl.asie.foamfix.coremod.patchers.GhostBusterWrapperPatcher;
import pl.asie.foamfix.coremod.patchers.LinuxGuiChatBrowsePatcher;
import pl.asie.foamfix.coremod.patchers.Log4JLoggerWrapperPatcher;
import pl.asie.foamfix.forkage.coremod.patchers.EntityLivingBaseItemNBTRenderFixPatcher;
import pl.asie.foamfix.forkage.coremod.patchers.JarDiscovererMemoryLeakFixPatcher;
import pl.asie.foamfix.forkage.coremod.patchers.SoundSystemUnpauseFixPatcher;
import pl.asie.foamfix.forkage.coremod.patchers.TessellatorAlphaPassWrapFixPatcher;
import pl.asie.foamfix.repack.com.unascribed.ears.common.agent.EarsAgent;

public class BugfixModClassTransformer
implements IClassTransformer {
    public static BugfixModClassTransformer instance;
    public File settingsFile;
    private boolean hasInit = false;
    public BugfixModSettings settings;
    private ArrayList<AbstractPatcher> globalPatchers = new ArrayList();
    private Map<String, ArrayList<AbstractPatcher>> patchers;
    public Logger logger = LogManager.getLogger((String)"foamfix");
    private static final int JNDILOOKUP_MOJANG_SIZE = 738;
    private static final byte[] JNDILOOKUP_MOJANG_SHA256;
    private static final int JNDILOOKUP_MULTIMC_SIZE = 983;
    private static final byte[] JNDILOOKUP_MULTIMC_SHA256;

    public BugfixModClassTransformer() {
        if (instance != null) {
            throw new RuntimeException("Only one transformer may exist!");
        }
        instance = this;
    }

    public void initialize(Boolean isObf) {
        if (!this.hasInit) {
            Class<?> c;
            Configuration config = new Configuration(this.settingsFile);
            config.load();
            this.settings = new BugfixModSettings();
            this.settings.gbEnableDebugger = config.get("ghostbuster", "enableDebugger", false, "Enable the /ghostbuster command used for logging ghost chunkloading events.").getBoolean(false);
            this.settings.gbDebuggerLogFilePath = config.get("ghostbuster", "debuggerLogFile", "", "Path of the log file for /ghostbuster logging; if empty, outputs to Minecraft log file.").getString().trim();
            this.settings.gbDebuggerLogFile = this.settings.gbDebuggerLogFilePath.isEmpty() ? null : new File(this.settings.gbDebuggerLogFilePath);
            this.settings.gbEnableFixes = config.get("ghostbuster", "enableFixes", true, "Main toggle. If disabled, none of the ghost chunkloading fixes are applied.").getBoolean(true);
            this.settings.gbFixGrassVanilla = config.get("ghostbuster", "fixGrassVanilla", true, "Fix ghost chunkloading caused by vanilla grass blocks.").getBoolean(true);
            this.settings.gbFixGrassBOP = config.get("ghostbuster", "fixGrassBop", true, "Fix ghost chunkloading caused by Biomes O' Plenty grass blocks.").getBoolean(true);
            this.settings.gbFixFluidsVanilla = config.get("ghostbuster", "fixFluidsVanilla", true, "Partially fix ghost chunkloading caused by vanilla fluid flow.").getBoolean(true);
            this.settings.gbFixFluidsModded = config.get("ghostbuster", "fixFluidsModded", true, "Fix ghost chunkloading caused by modded fluid blocks.").getBoolean(true);
            this.settings.gbFixVinesVanilla = config.get("ghostbuster", "fixVinesVanilla", true, "Fix ghost chunkloading caused by vanilla vine blocks.").getBoolean(true);
            this.settings.bfJarDiscovererMemoryLeakFixEnabled = config.get("bugfixes", "jarDiscovererMemoryLeakFix", true, "Fix native memory leak in JarDiscoverer (from Forkage by immibis)").getBoolean(true);
            this.settings.bfSoundSystemUnpauseFixEnabled = config.get("bugfixes", "soundSystemUnpauseFix", true, "Fix sounds playing extra times when you close a GUI or unpause the game (from Forkage by immibis)").getBoolean(true);
            this.settings.bfEntityHeldItemNBTRenderFixEnabled = config.get("bugfixes", "entityHeldItemNBTRenderFix", true, "Fix items held by mobs not reflecting their NBT status (from Forkage by immibis)").getBoolean(true);
            this.settings.bfAlphaPassTessellatorCrashFixEnabled = config.get("bugfixes", "tessellatorAlphaPassCrashFix", true, "Fix PriorityQueue tessellator crash on empty alpha pass.").getBoolean(true);
            this.settings.lwWeakenResourceCache = config.get("launchwrapper", "weakenResourceCache", true, "Weaken LaunchWrapper's byte[] resource cache to make it cleanuppable by the GC. Safe.").getBoolean(true);
            this.settings.lwRemovePackageManifestMap = config.get("launchwrapper", "removePackageManifestMap", true, "Remove LaunchWrapper package manifest map (which is not used anyway).").getBoolean(true);
            this.settings.ItemHopperBounceFixEnabled = config.get("bugfixes", "itemBounceHopperFix", false, "Fix items bouncing around on locked hoppers. (from BugfixMod by williewillus)").getBoolean(false);
            this.settings.ItemStairBounceFixEnabled = config.get("bugfixes", "itemBounceStairFix", false, "Fix items bouncing around on stairs. (from BugfixMod by williewillus)").getBoolean(false);
            this.settings.SnowballFixEnabled = config.get("bugfixes", "snowballFix", true, "Fix projectiles that deal 0 damage not knocking back players. (from BugfixMod by williewillus)").getBoolean(true);
            this.settings.ArrowDingTweakEnabled = config.get("tweaks", "arrowDing", false, "Emits a 'ding' sound when mobs are hit by an arrow, not just players. (from BugfixMod by williewillus)").getBoolean(false);
            this.settings.ChickenLureTweakEnabled = config.get("tweaks", "chickenLureFix", false, "Adds AI tasks that make chickens attracted to all items they can breed with, not just seeds. (from BugfixMod by williewillus)").getBoolean(false);
            this.settings.VillageAnvilTweakEnabled = config.get("tweaks", "villageAnvils", false, "Blacksmith houses generate with an anvil where there was a double stone slab (which was supposed to be an \"anvil\" anyway). (from BugfixMod by williewillus)").getBoolean(false);
            this.settings.BoatDesyncFixEnabled = config.get("bugfixes", "clientBoatDesyncFix", true, "Reduce the amount of boat desynchronization between client and server. (from BugfixMod by williewillus)").getBoolean(true);
            this.settings.HeartBlinkFixEnabled = config.get("bugfixes", "clientHeartBlinkFix", true, "Restore rendering the client-side heart blink. (from BugfixMod by williewillus)").getBoolean(true);
            this.settings.HeartFlashFixEnabled = config.get("bugfixes", "clientHeartFlashFix", true, "Restore lost hearts flashing to indicate loss. (from BugfixMod by williewillus)").getBoolean(true);
            this.settings.ToolDesyncFixEnabled = config.get("bugfixes", "clientToolDesyncFix", true, "Fix client-side desynchronization of damaged tools related to Unbreaking enchantments. (from BugfixMod by williewillus)").getBoolean(true);
            this.settings.bfLog4JExploitFixEnabled = config.get("bugfixes", "log4jExploitFix", true, "Fix Log4j formatting exploit.").getBoolean(true);
            this.settings.bfBiblioRCEFixEnabled = config.get("bugfixes", "biblioRceExploitFix", true, "Fix BiblioRCE exploit.").getBoolean(true);
            this.settings.mc18SkinSupport = config.get("tweaks", "mc18SkinSupport", true, "Add support for Minecraft 1.8+ skins.").getBoolean(true);
            this.settings.clOpenUrlLinux = config.get("tweaks", "openUrlLinux", true, "Fix opening URLs on Linux-based installs.").getBoolean(true);
            if (!Arrays.asList(new File(new File(this.settingsFile.getParent()).getParent()).list()).contains("saves")) {
                this.logger.info("You probably are on a dedicated server. Disabling client fixes");
                this.settings.BoatDesyncFixEnabled = false;
                this.settings.HeartBlinkFixEnabled = false;
                this.settings.HeartFlashFixEnabled = false;
            }
            config.save();
            MappingRegistry.init(isObf);
            this.setupPatchers();
            this.hasInit = true;
            if (this.settings.mc18SkinSupport) {
                try {
                    c = Class.forName("com.unascribed.ears.Ears");
                    this.settings.helloMmcg = false;
                }
                catch (Throwable t) {
                    this.settings.helloMmcg = true;
                }
            } else {
                this.settings.helloMmcg = false;
            }
            if (this.settings.helloMmcg) {
                try {
                    c = Class.forName("api.player.render.RenderPlayerAPI");
                    this.settings.helloMmcg = false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (this.hasInit) {
            ArrayList<AbstractPatcher> gpl = this.globalPatchers;
            for (AbstractPatcher p : gpl) {
                bytes = p.patch(transformedName, bytes);
            }
            List pl = this.patchers.get(transformedName);
            if (pl != null) {
                for (AbstractPatcher p : pl) {
                    bytes = p.patch(transformedName, bytes);
                }
            }
            if (this.settings.helloMmcg) {
                bytes = EarsAgent.transform(transformedName, bytes);
            }
        }
        return bytes;
    }

    private void setupPatchers() {
        if (this.patchers != null) {
            this.logger.warn("Patcher already initialized!!");
        } else {
            this.patchers = new HashMap<String, ArrayList<AbstractPatcher>>();
            if (this.settings.BoatDesyncFixEnabled) {
                this.addPatcher(new BoatDesyncFixPatcher_Main("BoatDesyncFix", "net/minecraft/entity/item/EntityBoat", MappingRegistry.getMethodNameFor("EntityBoat.setIsBoatEmpty"), "(Z)V"));
                this.addPatcher(new BoatDesyncFixPatcher_Extra("BoatDesyncFix|Extra", "net/minecraft/entity/item/EntityBoat", MappingRegistry.getMethodNameFor("EntityBoat.setPositionAndRotation2"), "(DDDFFI)V"));
            }
            if (this.settings.ChickenLureTweakEnabled) {
                this.addPatcher(new ChickenLureTweakPatcher("ChickenLureTweak", "net/minecraft/entity/passive/EntityChicken", "<init>", "(Lnet/minecraft/world/World;)V"));
            }
            if (this.settings.HeartBlinkFixEnabled) {
                this.addPatcher(new HeartBlinkFixPatcher("HeartBlinkFix", "net/minecraft/client/entity/EntityPlayerSP", MappingRegistry.getMethodNameFor("EntityPlayerSP.setPlayerSPHealth"), "(F)V"));
            }
            if (this.settings.HeartFlashFixEnabled) {
                this.addPatcher(new HeartFlashFixPatcher("HeartFlashFix", "net/minecraft/client/entity/EntityClientPlayerMP", MappingRegistry.getMethodNameFor("EntityClientPlayerMP.attackEntityFrom"), "(Lnet/minecraft/util/DamageSource;F)Z"));
            }
            if (!this.settings.HeartBlinkFixEnabled || this.settings.HeartFlashFixEnabled) {
                // empty if block
            }
            if (this.settings.ItemHopperBounceFixEnabled) {
                this.addPatcher(new ItemHopperBounceFixPatcher("ItemHopperBounceFix", "net/minecraft/block/BlockHopper", MappingRegistry.getMethodNameFor("BlockHopper.addCollisionBoxesToList"), "(Lnet/minecraft/world/World;IIILnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)V"));
            }
            if (this.settings.ItemStairBounceFixEnabled) {
                this.addPatcher(new ItemStairBounceFixPatcher("ItemStairBounceFix", "net/minecraft/block/BlockStairs", MappingRegistry.getMethodNameFor("BlockStairs.addCollisionBoxesToList"), "(Lnet/minecraft/world/World;IIILnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)V"));
            }
            if (this.settings.SnowballFixEnabled) {
                this.addPatcher(new SnowballFixPatcher("SnowballFix", "net/minecraft/entity/player/EntityPlayer", MappingRegistry.getMethodNameFor("EntityPlayer.attackEntityFrom"), "(Lnet/minecraft/util/DamageSource;F)Z"));
            }
            String sig2 = "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/world/gen/structure/StructureBoundingBox;)Z";
            if (this.settings.VillageAnvilTweakEnabled) {
                this.addPatcher(new VillageAnvilTweakPatcher("VillageAnvilTweak", "net/minecraft/world/gen/structure/StructureVillagePieces$House2", MappingRegistry.getMethodNameFor("StructureVillagePieces$House2.addComponentParts"), sig2));
            }
            if (this.settings.gbEnableDebugger) {
                this.addPatcher(new GhostBusterHookPatcher("GhostBusterHook", "net/minecraft/world/gen/ChunkProviderServer", MappingRegistry.getMethodNameFor("ChunkProviderServer.provideChunk"), null));
            }
            if (this.settings.gbEnableFixes) {
                if (this.settings.gbFixGrassVanilla) {
                    this.addPatcher(GhostBusterEarlyReturnPatcher.updateTick("net/minecraft/block/BlockGrass", 3));
                }
                if (this.settings.gbFixGrassBOP) {
                    this.addPatcher(GhostBusterEarlyReturnPatcher.updateTick("biomesoplenty/common/blocks/BlockBOPGrass", 3));
                }
                if (this.settings.gbFixFluidsVanilla) {
                    this.addPatcher(new GhostBusterWrapperPatcher("GhostBusterWrapStaticLiquid", "net/minecraft/block/BlockStaticLiquid", MappingRegistry.getMethodNameFor("Block.updateTick"), null));
                    this.addPatcher(new GhostBusterWrapperPatcher("GhostBusterWrapStaticLiquid", "net/minecraft/block/BlockStaticLiquid", MappingRegistry.getMethodNameFor("BlockStaticLiquid.isFlammable"), null));
                    this.addPatcher(GhostBusterEarlyReturnPatcher.updateTick("net/minecraft/block/BlockDynamicLiquid", 4));
                }
                if (this.settings.gbFixFluidsModded) {
                    this.addPatcher(GhostBusterEarlyReturnPatcher.updateTick("net/minecraftforge/fluids/BlockFluidClassic", 4));
                    this.addPatcher(GhostBusterEarlyReturnPatcher.updateTick("net/minecraftforge/fluids/BlockFluidFinite", 1));
                }
                if (this.settings.gbFixVinesVanilla) {
                    this.addPatcher(GhostBusterEarlyReturnPatcher.updateTick("net/minecraft/block/BlockVine", 4));
                }
            }
            if (this.settings.bfJarDiscovererMemoryLeakFixEnabled) {
                this.addPatcher(new JarDiscovererMemoryLeakFixPatcher("JarDiscovererMemoryLeakFix", "cpw/mods/fml/common/discovery/JarDiscoverer", "discover", "(Lcpw/mods/fml/common/discovery/ModCandidate;Lcpw/mods/fml/common/discovery/ASMDataTable;)Ljava/util/List;"));
            }
            if (this.settings.bfSoundSystemUnpauseFixEnabled) {
                this.addPatcher(new SoundSystemUnpauseFixPatcher("SoundSystemUnpauseFix", "net/minecraft/client/audio/SoundManager"));
            }
            if (this.settings.bfEntityHeldItemNBTRenderFixEnabled) {
                this.addPatcher(new EntityLivingBaseItemNBTRenderFixPatcher("EntityHeldItemNBTRenderFix", "net/minecraft/entity/EntityLivingBase"));
            }
            if (this.settings.bfAlphaPassTessellatorCrashFixEnabled) {
                this.addPatcher(new TessellatorAlphaPassWrapFixPatcher("AlphaPassTessellatorCrashFix", "net/minecraft/client/renderer/Tessellator"));
            }
            if (this.settings.clOpenUrlLinux) {
                this.addPatcher(new LinuxGuiChatBrowsePatcher("LinuxGuiChatBrowsePatch", "net/minecraft/client/gui/GuiChat"));
            }
            if (this.settings.bfLog4JExploitFixEnabled) {
                boolean vulnerableJndiLookupFound = true;
                InputStream jndiLookupStream = BugfixModClassTransformer.class.getClassLoader().getResourceAsStream("org/apache/logging/log4j/core/lookup/JndiLookup.class");
                if (jndiLookupStream == null) {
                    try {
                        if (Class.forName("org.apache.logging.log4j.core.lookup.JndiLookup") == null) {
                            vulnerableJndiLookupFound = false;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        vulnerableJndiLookupFound = false;
                    }
                }
                if (vulnerableJndiLookupFound) {
                    if (jndiLookupStream != null) {
                        try {
                            byte[] buffer = new byte[8192];
                            int readLen = 0;
                            int readLenLocal = 1;
                            while (readLenLocal > 0 && readLen < buffer.length) {
                                readLenLocal = jndiLookupStream.read(buffer, readLen, 8192 - readLen);
                                if (readLenLocal <= 0) continue;
                                readLen += readLenLocal;
                            }
                            byte[] expectedShaDigest = null;
                            String expectedShaDigestSource = null;
                            if (readLen == 983) {
                                expectedShaDigest = JNDILOOKUP_MULTIMC_SHA256;
                                expectedShaDigestSource = "MultiMC-patched";
                            } else if (readLen == 738) {
                                expectedShaDigest = JNDILOOKUP_MOJANG_SHA256;
                                expectedShaDigestSource = "Mojang-patched";
                            }
                            if (expectedShaDigest != null) {
                                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                                digest.update(buffer, 0, readLen);
                                byte[] jndiLookupSha = digest.digest();
                                if (Arrays.equals(jndiLookupSha, expectedShaDigest)) {
                                    this.logger.info(expectedShaDigestSource + " JndiLookup class detected; skipping Log4JExploitFix...");
                                    vulnerableJndiLookupFound = false;
                                }
                            }
                        }
                        catch (Exception e) {
                            try {
                                jndiLookupStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (vulnerableJndiLookupFound) {
                        this.addPatcher(new Log4JLoggerWrapperPatcher("Log4JExploitFix"));
                    }
                } else {
                    this.logger.info("Vulnerable JndiLookup class not found; skipping Log4JExploitFix...");
                }
            }
            if (this.settings.bfBiblioRCEFixEnabled) {
                this.addPatcher(new FileRCEPatcher("BiblioRCEFix", "jds/bibliocraft/FileUtil"));
            }
        }
    }

    private void addPatcher(AbstractPatcher patcher) {
        if (patcher.getTargetClassName() == null || patcher.getTargetClassName().isEmpty()) {
            this.globalPatchers.add(patcher);
            this.globalPatchers.trimToSize();
        } else {
            ArrayList list = this.patchers.computeIfAbsent(patcher.getTargetClassName(), k -> new ArrayList());
            list.add(patcher);
            list.trimToSize();
        }
    }

    static {
        JNDILOOKUP_MOJANG_SHA256 = new byte[]{-56, -115, 104, -45, -32, -128, 26, -73, -90, -95, 22, -31, -108, -95, 110, 43, 88, -91, -16, 99, -36, 29, 79, -76, -21, -37, -43, 26, 5, -84, 78, -40};
        JNDILOOKUP_MULTIMC_SHA256 = new byte[]{56, -53, 28, -94, -70, -64, 31, 31, 31, -21, -47, -83, 26, -123, -116, 112, 24, 89, 25, 65, -5, -107, 3, 45, 14, -58, 64, 98, 63, 39, 66, -125};
    }
}

