/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.VersionChecker;
import technicianlp.reauth.authentication.flows.Flows;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.AbstractScreen;
import technicianlp.reauth.gui.FlowScreen;
import technicianlp.reauth.gui.OfflineLoginScreen;
import technicianlp.reauth.gui.SaveButton;

public final class MainScreen
extends AbstractScreen {
    private SaveButton saveButton;
    private String message = null;

    public MainScreen(GuiScreen background) {
        super("reauth.gui.title.main", background);
    }

    @Override
    public final void func_73866_w_() {
        String msg;
        super.func_73866_w_();
        int buttonWidthH = 98;
        int y = this.centerY - 55;
        SaveButton.ITooltip saveButtonTooltip = (mouseX, mouseY) -> {
            this.drawHoveringText(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"reauth.gui.button.save.tooltip", (Object[])new Object[0]), 250), mouseX, mouseY, this.field_146289_q);
            RenderHelper.func_74518_a();
        };
        this.saveButton = new SaveButton(0, this.centerX - buttonWidthH, y + 70, I18n.func_135052_a((String)"reauth.gui.button.save", (Object[])new Object[0]), saveButtonTooltip);
        this.field_146292_n.add(this.saveButton);
        Profile profile = ReAuth.profiles.getProfile();
        if (profile != null) {
            String text = I18n.func_135052_a((String)"reauth.gui.profile", (Object[])new Object[]{profile.getValue("name", "Steve")});
            this.field_146292_n.add(new GuiButton(2, this.centerX - buttonWidthH, y + 10, 196, 20, text));
        } else {
            GuiButton profileButton = new GuiButton(0, this.centerX - buttonWidthH, y + 10, 196, 20, I18n.func_135052_a((String)"reauth.gui.noProfile", (Object[])new Object[0]));
            profileButton.field_146124_l = false;
            this.field_146292_n.add(profileButton);
        }
        this.field_146292_n.add(new GuiButton(3, this.centerX - buttonWidthH, y + 45, buttonWidthH - 1, 20, I18n.func_135052_a((String)"reauth.gui.button.authcode", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(4, this.centerX + 1, y + 45, buttonWidthH - 1, 20, I18n.func_135052_a((String)"reauth.gui.button.devicecode", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(5, this.centerX - buttonWidthH, y + 105, 196, 20, I18n.func_135052_a((String)"reauth.gui.button.offline", (Object[])new Object[0])));
        if (ReAuth.versionCheck.getStatus() == VersionChecker.Status.OUTDATED && (msg = ReAuth.versionCheck.getChanges()) != null) {
            this.message = I18n.func_135052_a((String)"reauth.gui.auth.update", (Object[])new Object[]{msg});
        }
    }

    @Override
    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int x = this.centerX - 98;
        this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"reauth.gui.text.profile", (Object[])new Object[0]), x, this.centerY - 55, -1);
        this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"reauth.gui.text.microsoft", (Object[])new Object[0]), x, this.centerY - 20, -1);
        this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"reauth.gui.text.offline", (Object[])new Object[0]), x, this.centerY + 40, -1);
        if (this.message != null) {
            this.field_146289_q.func_78261_a(this.message, x, this.baseY + 20, -1);
        }
        this.saveButton.drawTooltip(mouseX, mouseY);
    }

    @Override
    protected final void requestClose(boolean completely) {
        this.field_146297_k.func_147108_a(this.background);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 2: {
                Profile profile = ReAuth.profiles.getProfile();
                if (profile == null) break;
                FlowScreen.open(Flows::loginWithProfile, profile, this.background);
                break;
            }
            case 3: {
                FlowScreen.open(Flows::loginWithAuthCode, this.saveButton.isChecked(), this.background);
                break;
            }
            case 4: {
                FlowScreen.open(Flows::loginWithDeviceCode, this.saveButton.isChecked(), this.background);
                break;
            }
            case 5: {
                this.field_146297_k.func_147108_a((GuiScreen)new OfflineLoginScreen(this.background));
            }
        }
    }
}

