/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.flows;

import technicianlp.reauth.authentication.flows.AuthorizationCodeFlow;
import technicianlp.reauth.authentication.flows.DeviceCodeFlow;
import technicianlp.reauth.authentication.flows.Flow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.impl.MicrosoftCodeFlow;
import technicianlp.reauth.authentication.flows.impl.MicrosoftDeviceFlow;
import technicianlp.reauth.authentication.flows.impl.MicrosoftProfileFlow;
import technicianlp.reauth.authentication.flows.impl.MojangAuthenticationFlow;
import technicianlp.reauth.authentication.flows.impl.UnknownProfileFlow;
import technicianlp.reauth.configuration.Profile;

public final class Flows {
    public static Flow loginWithProfile(Profile profile, FlowCallback callback) {
        switch (profile.getValue("type")) {
            case "microsoft": {
                return new MicrosoftProfileFlow(profile, callback);
            }
            case "mojang": {
                return new MojangAuthenticationFlow(profile, callback);
            }
        }
        return new UnknownProfileFlow(callback);
    }

    public static AuthorizationCodeFlow loginWithAuthCode(boolean persist, FlowCallback callback) {
        return new MicrosoftCodeFlow(persist, callback);
    }

    public static DeviceCodeFlow loginWithDeviceCode(boolean persist, FlowCallback callback) {
        return new MicrosoftDeviceFlow(persist, callback);
    }

    public static Flow loginWithMojang(String username, String password, boolean persist, FlowCallback callback) {
        return new MojangAuthenticationFlow(username, password, persist, callback);
    }
}

