/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.dto.xbox;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;
import technicianlp.reauth.authentication.dto.ResponseObject;

public final class XboxAuthResponse
implements ResponseObject {
    public final String validUntil;
    public final String token;
    public final String userHash;
    @Nullable
    public final String error;

    private XboxAuthResponse(String validUntil, String token, String userHash, String error) {
        this.validUntil = validUntil;
        this.token = token;
        this.userHash = userHash;
        this.error = error;
    }

    @Override
    public final boolean isValid() {
        return this.error == null && this.validUntil != null && this.token != null && this.userHash != null;
    }

    @Override
    @Nullable
    public final String getError() {
        return this.error;
    }

    public final String getToken() {
        return this.token;
    }

    public static final class Deserializer
    implements JsonDeserializer<XboxAuthResponse> {
        public final XboxAuthResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject root = json.getAsJsonObject();
                String validUntil = this.getString(root, "NotAfter");
                String token = this.getString(root, "Token");
                String userHash = this.extractUserHash(root.getAsJsonObject("DisplayClaims"));
                String error = this.getString(root, "XErr");
                return new XboxAuthResponse(validUntil, token, userHash, error);
            }
            catch (ClassCastException | IllegalStateException e) {
                throw new JsonParseException("invalid format", (Throwable)e);
            }
        }

        private String getString(JsonObject root, String name) {
            JsonPrimitive primitive = root.getAsJsonPrimitive(name);
            if (primitive != null) {
                return primitive.getAsString();
            }
            return null;
        }

        private String extractUserHash(JsonObject displayClaims) {
            JsonArray xui;
            if (displayClaims != null && (xui = displayClaims.getAsJsonArray("xui")) != null) {
                for (JsonElement claim : xui) {
                    JsonPrimitive uhs = claim.getAsJsonObject().getAsJsonPrimitive("uhs");
                    if (uhs == null) continue;
                    return uhs.getAsString();
                }
            }
            return null;
        }
    }
}

