/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import technicianlp.reauth.ReAuth;

public final class VersionChecker
implements Runnable {
    private static final String MC_VERSION = "1.7.10";
    private static final String JSON_URL = "https://github.com/TechnicianLP/ReAuth/raw/master/update.json";
    private Status status = Status.UNKNOWN;
    private String changes = null;

    @Override
    public void run() {
        try {
            ReAuth.log.info("Starting version check");
            this.status = Status.UNKNOWN;
            this.changes = null;
            InputStream inputstream = new URL(JSON_URL).openStream();
            String data = IOUtils.toString((InputStream)inputstream, (Charset)StandardCharsets.UTF_8);
            inputstream.close();
            VersionJson json = (VersionJson)new Gson().fromJson(data, VersionJson.class);
            String latestVersion = json.versions.get("1.7.10-recommended");
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get("reauth");
            String current = container.getVersion();
            int currentVersionId = VersionChecker.versionToInt(current);
            if (latestVersion != null) {
                int latestVersionId = VersionChecker.versionToInt(latestVersion);
                this.status = currentVersionId < latestVersionId ? Status.OUTDATED : Status.OK;
            }
            this.changes = json.changelog.get(latestVersion);
            ReAuth.log.info("Version check completed with status: " + (Object)((Object)this.status));
        }
        catch (Exception e) {
            ReAuth.log.warn("Failed to process update information", (Throwable)e);
            this.status = Status.FAILED;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public String getChanges() {
        return this.changes;
    }

    private static int versionToInt(String version) {
        String[] split = version.split("\\.", 3);
        int ver = 0;
        for (String s : split) {
            ver = ver << 8 | Integer.parseInt(s);
        }
        return ver;
    }

    public static enum Status {
        FAILED,
        OK,
        OUTDATED,
        UNKNOWN;

    }

    private static class VersionJson {
        @SerializedName(value="promos")
        Map<String, String> versions = new HashMap<String, String>();
        @SerializedName(value="1.7.10")
        Map<String, String> changelog = new HashMap<String, String>();

        private VersionJson() {
        }
    }
}

