/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketAnimationAbsorb;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.network.packets.PacketTCNodeBolt;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;

public class ExplosionHelper {
    public static void taintplosion(World world, int x, int y, int z, boolean taintBiome, int chanceToTaint) {
        ExplosionHelper.taintplosion(world, x, y, z, taintBiome, chanceToTaint, 3.0f, 10, 80);
    }

    public static void taintplosion(World world, int x, int y, int z, boolean taintBiome, int chanceToTaint, float str, int size, int blocksAffected) {
        if (chanceToTaint < 1) {
            chanceToTaint = 1;
        }
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, str, false);
        for (int a = 0; a < blocksAffected; ++a) {
            int zz;
            int yy;
            int xx = x + world.field_73012_v.nextInt(size) - world.field_73012_v.nextInt(size);
            if (world.func_147437_c(xx, yy = y + world.field_73012_v.nextInt(size) - world.field_73012_v.nextInt(size), zz = z + world.field_73012_v.nextInt(size) - world.field_73012_v.nextInt(size))) {
                if (yy < y) {
                    world.func_147465_d(xx, yy, zz, ConfigBlocks.blockFluxGoo, 8, 3);
                } else {
                    world.func_147465_d(xx, yy, zz, ConfigBlocks.blockFluxGas, 8, 3);
                }
            }
            if (!Config.genTaint || !taintBiome || world.field_73012_v.nextInt(chanceToTaint) != 0) continue;
            Utils.setBiomeAt((World)world, (int)xx, (int)zz, (BiomeGenBase)ThaumcraftWorldGenerator.biomeTaint);
        }
    }

    public static class VortexExplosion {
        private TileExtendedNode causingNode;
        private int tick;
        private int phase;
        private World world;
        private int x;
        private int y;
        private int z;
        private List<Vec3> pastTickBlocks = null;

        public VortexExplosion(TileExtendedNode exNode) {
            this.causingNode = exNode;
            this.world = exNode.func_145831_w();
            this.x = exNode.field_145851_c;
            this.y = exNode.field_145848_d;
            this.z = exNode.field_145849_e;
            this.phase = 0;
            this.tick = 0;
        }

        public void update() {
            List livingEntities = this.world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)(this.y + 1), (double)(this.z + 1)).func_72314_b(6.0, 6.0, 6.0));
            if (livingEntities != null && livingEntities.size() > 0) {
                for (Object e : livingEntities) {
                    EntityLivingBase livingEntity = (EntityLivingBase)e;
                    if (!livingEntity.func_70089_S() || livingEntity.func_85032_ar() || livingEntity instanceof EntityPlayer && ((EntityPlayer)livingEntity).field_71075_bZ.field_75098_d || this.world.field_73012_v.nextInt(16) != 0) continue;
                    livingEntity.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    PacketTCNodeBolt packet = new PacketTCNodeBolt((float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f, (float)livingEntity.field_70165_t, (float)(livingEntity.field_70163_u + (double)livingEntity.field_70131_O), (float)livingEntity.field_70161_v, 0, false);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(this.world.field_73011_w.field_76574_g, (double)this.x, (double)this.y, (double)this.z, 32.0));
                }
            }
            if (this.phase < 2 && this.world.field_73012_v.nextInt(this.phase == 0 ? 8 : 4) == 0) {
                PacketStartAnimation packet = new PacketStartAnimation(2, this.x, this.y, this.z);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(this.world.field_73011_w.field_76574_g, (double)this.x, (double)this.y, (double)this.z, 32.0));
                this.world.func_72908_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "thaumcraft:ice", 0.8f, 1.0f);
            }
            switch (this.phase) {
                case 0: {
                    ++this.tick;
                    if (this.tick > 200) {
                        this.tick = 0;
                        this.phase = 1;
                        ExplosionHelper.taintplosion(this.world, this.x, this.y, this.z, false, 1);
                    }
                    this.sendRandomVortexLightningPacket(this.world, this.x, this.y, this.z);
                    break;
                }
                case 1: {
                    int range;
                    ++this.tick;
                    int n = this.tick > 50 ? (this.tick > 75 ? (this.tick > 100 ? (this.tick > 200 ? (this.tick > 300 ? 9 : 7) : 6) : 5) : 4) : (range = 3);
                    if (this.pastTickBlocks != null) {
                        for (Vec3 v : this.pastTickBlocks) {
                            this.sendRandomVortexLightningPacket(this.world, this.x, this.y, this.z);
                            this.world.func_147468_f((int)v.field_72450_a, (int)v.field_72448_b, (int)v.field_72449_c);
                        }
                    }
                    for (int ct = this.world.field_73012_v.nextInt(4); ct > 0; --ct) {
                        this.sendRandomVortexLightningPacket(this.world, this.x, this.y, this.z);
                    }
                    this.pastTickBlocks = new ArrayList<Vec3>();
                    int cnt = 10;
                    do {
                        int xx = this.x + this.world.field_73012_v.nextInt(range) - this.world.field_73012_v.nextInt(range);
                        int yy = this.y + this.world.field_73012_v.nextInt(range) - this.world.field_73012_v.nextInt(range);
                        int zz = this.z + this.world.field_73012_v.nextInt(range) - this.world.field_73012_v.nextInt(range);
                        Block b = this.world.func_147439_a(xx, yy, zz);
                        float hardness = b.func_149712_f(this.world, xx, yy, zz);
                        if (b == Blocks.field_150350_a || !(hardness > 0.0f) || !(hardness <= 50.0f) || b == RegisteredBlocks.blockNode) continue;
                        PacketAnimationAbsorb absorb = new PacketAnimationAbsorb(this.x, this.y, this.z, xx, yy, zz, 7);
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)absorb, new NetworkRegistry.TargetPoint(this.world.field_73011_w.field_76574_g, (double)this.x, (double)this.y, (double)this.z, 32.0));
                        this.pastTickBlocks.add(Vec3.func_72443_a((double)xx, (double)yy, (double)zz));
                    } while (--cnt > 0);
                    if (this.tick == 200) {
                        ExplosionHelper.taintplosion(this.world, this.x, this.y, this.z, false, 1);
                    }
                    if (this.tick == 300) {
                        ExplosionHelper.taintplosion(this.world, this.x, this.y, this.z, false, 1);
                    }
                    if (this.tick <= 400) break;
                    this.phase = 2;
                    this.reduceAspects(this.causingNode);
                    ExplosionHelper.taintplosion(this.world, this.x, this.y, this.z, true, 3);
                    break;
                }
            }
        }

        private void reduceAspects(TileExtendedNode node) {
            ArrayList<Aspect> lostAspects = new ArrayList<Aspect>();
            AspectList list = node.getAspectsBase();
            for (Object a : list.getAspects()) {
                if (this.world.field_73012_v.nextInt(4) == 0) {
                    lostAspects.add((Aspect)a);
                    continue;
                }
                list.reduce(a, list.getAmount(a) / 2);
            }
            for (Aspect lost : lostAspects) {
                node.getAspectsBase().remove(lost);
                node.getAspects().remove(lost);
            }
            list = node.getAspects();
            for (Object a : list.getAspects()) {
                list.reduce(a, list.getAmount(a) / 2);
            }
            node.func_145831_w().func_147471_g(node.field_145851_c, node.field_145848_d, node.field_145849_e);
            node.func_70296_d();
        }

        private void sendRandomVortexLightningPacket(World world, int x, int y, int z) {
            PacketStartAnimation animationPacket = new PacketStartAnimation(1, x, y, z);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 32.0);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)animationPacket, point);
        }

        public static void vortexLightning(TileExtendedNode te) {
            World world = te.func_145831_w();
            int x = te.field_145851_c;
            int y = te.field_145848_d;
            int z = te.field_145849_e;
            float xx = x + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3);
            float yy = y + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3);
            float zz = z + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3);
            Thaumcraft.proxy.nodeBolt(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, xx += world.field_73012_v.nextFloat() * (float)(world.field_73012_v.nextBoolean() ? 1 : -1), yy += world.field_73012_v.nextFloat() * (float)(world.field_73012_v.nextBoolean() ? 1 : -1), zz += world.field_73012_v.nextFloat() * (float)(world.field_73012_v.nextBoolean() ? 1 : -1));
        }

        public boolean isFinished() {
            return this.phase > 1;
        }
    }
}

